<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('include/entryPoint.php');
require_once('data/BeanFactory.php');
require_once('include/utils.php');

$username = isset($_GET['username']) ? trim($_GET['username']) : '';
$lastname = isset($_GET['lastname']) ? trim($_GET['lastname']) : '';
$phone = isset($_GET['phone']) ? trim($_GET['phone']) : '';

header('Content-Type: application/json');

if (empty($username) || empty($lastname) || empty($phone)) {
    die(json_encode(['status' => 'error', 'message' => 'Missing required parameters']));
}

// Check if phone_mobile already exists
global $db;
$phone_escaped = $db->quote($phone);
$query = "SELECT id FROM contacts WHERE deleted = 0 AND phone_mobile = '{$phone_escaped}' LIMIT 1";
$result = $db->query($query);

if ($row = $db->fetchByAssoc($result)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'A contact with this phone number already exists.',
        'existing_contact_id' => $row['id']
    ]);
    return;
}

// Create a new Contact bean
$contact = BeanFactory::newBean('Contacts');
$contact->username_c = $username;
$contact->first_name = "";
$contact->last_name = $lastname;
$contact->phone_mobile = $phone;
$contact->call_status_c = "haventcall";

// Manually set the created/modified dates to GMT+6
$now_utc = new DateTime('now', new DateTimeZone('UTC'));
$now_gmt6 = $now_utc->setTimezone(new DateTimeZone('Asia/Dhaka')); // GMT+6

$formatted_date = $now_gmt6->format('Y-m-d H:i:s');

// $contact->date_entered = $formatted_date;
// $contact->date_modified = $formatted_date;

// Save the record
$contact->save();

// Optional: update the DB directly to make sure dates are not overridden by framework
$contact_id_escaped = $db->quote($contact->id);
$update_query = "
    UPDATE contacts 
    SET date_entered = '{$formatted_date}', date_modified = '{$formatted_date}' 
    WHERE id = '{$contact_id_escaped}'";
$db->query($update_query);

echo json_encode([
    'status' => 'success',
    'message' => 'Contact created successfully',
    'contact_id' => $contact->id
]);
