/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { OverridableMap } from '../../types/overridable-map';
export class BaseComponentRegistry {
    constructor() {
        this.init();
    }
    static getKey(type) {
        return type;
    }
    register(module, type, component) {
        this.map.addEntry(module, BaseComponentRegistry.getKey(type), component);
    }
    exclude(module, key) {
        this.map.excludeEntry(module, key);
    }
    get(module, type) {
        const components = this.map.getGroupEntries(module);
        let key = BaseComponentRegistry.getKey(type);
        if (components[key]) {
            return components[key];
        }
        return null;
    }
    has(module, type) {
        const components = this.map.getGroupEntries(module);
        const key = BaseComponentRegistry.getKey(type);
        return !!components[key];
    }
    init() {
        this.map = new OverridableMap();
        this.initDefault();
    }
    initDefault() {
    }
}
//# sourceMappingURL=data:application/json;base64,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