/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { OverridableMap } from 'common';
export class BaseFieldRegistry {
    constructor() {
        this.init();
    }
    register(module, type, mode, component) {
        this.map.addEntry(module, BaseFieldRegistry.getKey(type, mode), component);
    }
    registerField(module, field, mode, component) {
        this.fieldMap.addEntry(module, BaseFieldRegistry.getKey(field, mode), component);
    }
    exclude(module, key) {
        this.map.excludeEntry(module, key);
    }
    getDisplayType(module, type, displayType, mode, field) {
        const displayTypeKey = this.getDisplayTypeKey(type, displayType);
        if (this.hasFieldOverride(module, field, mode)) {
            return this.getFieldOverride(module, type, mode, field);
        }
        if (displayType && this.has(module, displayTypeKey, mode)) {
            return this.get(module, displayTypeKey, mode, field);
        }
        return this.get(module, type, mode, field);
    }
    get(module, type, mode, field) {
        const moduleFields = this.map.getGroupEntries(module);
        let key = BaseFieldRegistry.getKey(type, mode);
        if (moduleFields[key]) {
            return moduleFields[key];
        }
        if (mode === 'massupdate') {
            key = BaseFieldRegistry.getKey(type, 'edit');
            if (moduleFields[key]) {
                return moduleFields[key];
            }
        }
        const defaultKey = BaseFieldRegistry.getKey('varchar', mode);
        return moduleFields[defaultKey];
    }
    getFieldOverride(module, type, mode, field) {
        const moduleFields = this.fieldMap.getGroupEntries(module);
        let key = BaseFieldRegistry.getKey(field, mode);
        if (moduleFields[key]) {
            return moduleFields[key];
        }
        if (mode === 'massupdate') {
            key = BaseFieldRegistry.getKey(field, 'edit');
            if (moduleFields[key]) {
                return moduleFields[key];
            }
        }
        return null;
    }
    has(module, type, mode) {
        const moduleFields = this.map.getGroupEntries(module);
        const key = BaseFieldRegistry.getKey(type, mode);
        return !!moduleFields[key];
    }
    hasFieldOverride(module, field, mode) {
        const moduleFields = this.fieldMap.getGroupEntries(module);
        const key = BaseFieldRegistry.getKey(field, mode);
        return !!moduleFields[key];
    }
    static getKey(type, mode) {
        return type + '.' + mode;
    }
    getDisplayTypeKey(type, displayType) {
        if (!type || !displayType) {
            return '';
        }
        return type + '-' + displayType;
    }
    init() {
        this.map = new OverridableMap();
        this.fieldMap = new OverridableMap();
        Object.keys(this.getDefaultMap()).forEach(key => {
            const [type, mode] = key.split('.', 2);
            this.register('default', type, mode, this.getDefaultMap()[key]);
        });
    }
    getDefaultMap() {
        return {};
    }
}
//# sourceMappingURL=data:application/json;base64,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