/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from '@angular/core';
import { DataTypeFormatter } from '../../services/formatters/data-type.formatter.service';
import { StandardFieldRegistry } from '../standard-field.registry';
import { RecordManager } from '../../services/record/record.manager';
import { BaseComposite } from '../base/base-composite.component';
import { FieldLogicManager } from '../field-logic/field-logic.manager';
import { FieldLogicDisplayManager } from '../field-logic-display/field-logic-display.manager';
import * as i0 from "@angular/core";
import * as i1 from "../../services/formatters/data-type.formatter.service";
import * as i2 from "../standard-field.registry";
import * as i3 from "../../services/record/record.manager";
import * as i4 from "../field-logic/field-logic.manager";
import * as i5 from "../field-logic-display/field-logic-display.manager";
import * as i6 from "@angular/common";
import * as i7 from "../../components/label/label.component";
import * as i8 from "../dynamic-field/dynamic-field.component";
function CompositeComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-label", 1);
    i0.ɵɵelementContainerEnd();
} }
function CompositeComponent_ng_container_1_div_2_label_2_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "span", 7);
    i0.ɵɵtext(2, "*");
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} }
const _c0 = function () { return ["edit", "create"]; };
function CompositeComponent_ng_container_1_div_2_label_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label");
    i0.ɵɵelement(1, "scrm-label", 6);
    i0.ɵɵtemplate(2, CompositeComponent_ng_container_1_div_2_label_2_ng_container_2_Template, 3, 0, "ng-container", 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const attribute_r3 = i0.ɵɵnextContext().$implicit;
    const ctx_r4 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("labelKey", attribute_r3.labelKey)("module", ctx_r4.getModule());
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", attribute_r3.definition.required && i0.ɵɵpureFunction0(3, _c0).includes(ctx_r4.mode));
} }
function CompositeComponent_ng_container_1_div_2_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 8);
    i0.ɵɵelement(1, "scrm-dynamic-field", 9);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const attribute_r3 = i0.ɵɵnextContext().$implicit;
    const ctx_r5 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("componentType", ctx_r5.getComponentType(attribute_r3.type, attribute_r3.definition))("field", attribute_r3)("klass", ctx_r5.klass)("mode", ctx_r5.getMode())("originalMode", ctx_r5.originalMode)("record", ctx_r5.record)("parent", ctx_r5.parent)("type", attribute_r3.type);
} }
function CompositeComponent_ng_container_1_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "span", 4);
    i0.ɵɵtemplate(2, CompositeComponent_ng_container_1_div_2_label_2_Template, 3, 4, "label", 0);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, CompositeComponent_ng_container_1_div_2_span_3_Template, 2, 8, "span", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const attribute_r3 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵclassProp("flex-fill", ctx_r2.mode === "edit" && ctx_r2.getDirection() === "flex-row")("align-self-start", ctx_r2.getDirection() === "flex-row" && attribute_r3.labelKey && ctx_r2.showLabel(attribute_r3));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", attribute_r3.labelKey && ctx_r2.showLabel(attribute_r3));
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", attribute_r3.type);
} }
function CompositeComponent_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div");
    i0.ɵɵtemplate(2, CompositeComponent_ng_container_1_div_2_Template, 4, 6, "div", 2);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵclassMapInterpolate1("d-flex ", ctx_r1.getDirection(), " justify-content-start align-items-end field-group h-100 composite-field-wrapper");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", ctx_r1.getAttributes());
} }
class CompositeComponent extends BaseComposite {
    constructor(typeFormatter, registry, recordManager, logic, logicDisplay) {
        super(typeFormatter, registry, recordManager, logic, logicDisplay);
        this.typeFormatter = typeFormatter;
        this.registry = registry;
        this.recordManager = recordManager;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
    }
    static { this.ɵfac = function CompositeComponent_Factory(t) { return new (t || CompositeComponent)(i0.ɵɵdirectiveInject(i1.DataTypeFormatter), i0.ɵɵdirectiveInject(i2.StandardFieldRegistry), i0.ɵɵdirectiveInject(i3.RecordManager), i0.ɵɵdirectiveInject(i4.FieldLogicManager), i0.ɵɵdirectiveInject(i5.FieldLogicDisplayManager)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CompositeComponent, selectors: [["scrm-composite-field"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 2, vars: 2, consts: [[4, "ngIf"], ["labelKey", "LBL_BAD_GROUP_FIELD_CONFIG"], ["class", "field-group-item d-flex flex-column justify-content-end h-100 w-100", 3, "flex-fill", "align-self-start", 4, "ngFor", "ngForOf"], [1, "field-group-item", "d-flex", "flex-column", "justify-content-end", "h-100", "w-100"], [1, "field-group-label", "pt-2", "pr-1"], ["class", "field-group-field pr-1 pb-1 composite-field", 4, "ngIf"], [3, "labelKey", "module"], [1, "required"], [1, "field-group-field", "pr-1", "pb-1", "composite-field"], [3, "componentType", "field", "klass", "mode", "originalMode", "record", "parent", "type"]], template: function CompositeComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, CompositeComponent_ng_container_0_Template, 2, 0, "ng-container", 0);
            i0.ɵɵtemplate(1, CompositeComponent_ng_container_1_Template, 3, 4, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !ctx.isConfigured());
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngIf", ctx.isConfigured());
        } }, dependencies: [i6.NgForOf, i6.NgIf, i7.LabelComponent, i8.DynamicFieldComponent], encapsulation: 2 }); }
}
export { CompositeComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CompositeComponent, [{
        type: Component,
        args: [{ selector: 'scrm-composite-field', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"!isConfigured()\">\n    <scrm-label labelKey=\"LBL_BAD_GROUP_FIELD_CONFIG\"></scrm-label>\n</ng-container>\n\n<ng-container *ngIf=\"isConfigured()\">\n    <div class=\"d-flex {{getDirection()}} justify-content-start align-items-end field-group h-100 composite-field-wrapper\">\n\n        <div *ngFor=\"let attribute of getAttributes()\"\n             [class.flex-fill]=\"mode ==='edit' && getDirection() === 'flex-row'\"\n             [class.align-self-start]=\"getDirection() === 'flex-row' && attribute.labelKey && showLabel(attribute)\"\n             class=\"field-group-item d-flex flex-column justify-content-end h-100 w-100\">\n\n            <!-- LABEL -->\n            <span class=\"field-group-label pt-2 pr-1\">\n                <label *ngIf=\"attribute.labelKey && showLabel(attribute)\">\n                    <scrm-label [labelKey]=\"attribute.labelKey\" [module]=\"getModule()\"></scrm-label>\n                    <ng-container *ngIf=\"attribute.definition.required && (['edit', 'create'].includes(mode))\">\n                        <span class=\"required\">*</span>\n                    </ng-container>\n                </label>\n            </span>\n\n            <!-- VALUE -->\n            <span *ngIf=\"attribute.type\" class=\"field-group-field pr-1 pb-1 composite-field\">\n\n                <scrm-dynamic-field [componentType]=\"getComponentType(attribute.type, attribute.definition)\"\n                                    [field]=\"attribute\"\n                                    [klass]=\"klass\"\n                                    [mode]=\"getMode()\"\n                                    [originalMode]=\"originalMode\"\n                                    [record]=\"record\"\n                                    [parent]=\"parent\"\n                                    [type]=\"attribute.type\">\n                </scrm-dynamic-field>\n\n            </span>\n        </div>\n    </div>\n</ng-container>\n" }]
    }], function () { return [{ type: i1.DataTypeFormatter }, { type: i2.StandardFieldRegistry }, { type: i3.RecordManager }, { type: i4.FieldLogicManager }, { type: i5.FieldLogicDisplayManager }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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