/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2023 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { ConditionOperatorActionHandler } from '../condition-operator.action';
import * as i0 from "@angular/core";
class IsEqualAction extends ConditionOperatorActionHandler {
    constructor() {
        super();
        this.key = 'is-equal';
    }
    run(record, field, opsConfig) {
        let comparisonValue = null;
        if (this.compareToField(opsConfig)) {
            comparisonValue = this.getFieldComparisonValue(record, opsConfig);
        }
        else {
            comparisonValue = this.getStaticComparisonValue(opsConfig);
        }
        if (comparisonValue) {
            return comparisonValue.includes(field.value.toString());
        }
        return false;
    }
    getFieldComparisonValue(record, opsConfig) {
        return [record.fields[opsConfig.field]?.value];
    }
    getStaticComparisonValue(opsConfig) {
        if (Array.isArray(opsConfig.values)) {
            return opsConfig.values.map(value => value?.toString());
        }
        return [opsConfig.value].map(value => value?.toString());
    }
    compareToField(opsConfig) {
        if (opsConfig?.field) {
            return true;
        }
        return false;
    }
    static { this.ɵfac = function IsEqualAction_Factory(t) { return new (t || IsEqualAction)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: IsEqualAction, factory: IsEqualAction.ɵfac, providedIn: 'root' }); }
}
export { IsEqualAction };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IsEqualAction, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();
//# sourceMappingURL=data:application/json;base64,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