import { deepClone } from 'common';
import { Injectable } from '@angular/core';
import { isNil } from "lodash-es";
import * as i0 from "@angular/core";
class BaseSaveRecordMapper {
    getKey() {
        return 'base';
    }
    map(record) {
        if (!record.fields || !Object.keys(record.fields).length) {
            return;
        }
        Object.keys(record.fields).forEach(fieldName => {
            const field = record.fields[fieldName];
            const type = field.type || '';
            const source = field.definition.source || '';
            const rname = field.definition.rname || 'name';
            const idName = field.definition.id_name || '';
            if (type === 'relate' && source === 'non-db' && idName === fieldName) {
                record.attributes[fieldName] = field.value;
                return;
            }
            if (type === 'relate' && source === 'non-db' && rname !== '' && field.valueObject) {
                const attribute = record.attributes[fieldName] || {};
                attribute[rname] = field.valueObject[rname];
                attribute.id = field.valueObject.id;
                record.attributes[fieldName] = attribute;
                record.attributes[idName] = field.valueObject.id;
                return;
            }
            if (field.valueObject) {
                record.attributes[fieldName] = field.valueObject;
                return;
            }
            if (field.items) {
                record.attributes[fieldName] = [];
                field.items.forEach(item => {
                    if (!item?.id && item?.attributes?.deleted) {
                        return;
                    }
                    record.attributes[fieldName].push({
                        id: item.id,
                        module: item.module,
                        attributes: deepClone(item.attributes)
                    });
                });
                return;
            }
            if (field.valueObjectArray) {
                record.attributes[fieldName] = field.valueObjectArray;
                return;
            }
            if (field.valueList) {
                record.attributes[fieldName] = field.valueList;
                return;
            }
            if (field.vardefBased && (isNil(field.value) || field.value === '')) {
                if (!isNil(record.attributes[fieldName])) {
                    delete record.attributes[fieldName];
                }
                return;
            }
            record.attributes[fieldName] = field.value;
        });
    }
    static { this.ɵfac = function BaseSaveRecordMapper_Factory(t) { return new (t || BaseSaveRecordMapper)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: BaseSaveRecordMapper, factory: BaseSaveRecordMapper.ɵfac, providedIn: 'root' }); }
}
export { BaseSaveRecordMapper };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BaseSaveRecordMapper, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1zYXZlLnJlY29yZC1tYXBwZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9jb3JlL2FwcC9jb3JlL3NyYy9saWIvc3RvcmUvcmVjb3JkL3JlY29yZC1tYXBwZXJzL2Jhc2Utc2F2ZS5yZWNvcmQtbWFwcGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBQyxTQUFTLEVBQXVCLE1BQU0sUUFBUSxDQUFDO0FBQ3ZELE9BQU8sRUFBQyxVQUFVLEVBQUMsTUFBTSxlQUFlLENBQUM7QUFDekMsT0FBTyxFQUFDLEtBQUssRUFBQyxNQUFNLFdBQVcsQ0FBQzs7QUFFaEMsTUFHYSxvQkFBb0I7SUFFN0IsTUFBTTtRQUNGLE9BQU8sTUFBTSxDQUFDO0lBQ2xCLENBQUM7SUFFRCxHQUFHLENBQUMsTUFBYztRQUVkLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxFQUFFO1lBQ3RELE9BQU87U0FDVjtRQUVELE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtZQUMzQyxNQUFNLEtBQUssR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1lBRXZDLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLElBQUksRUFBRSxDQUFDO1lBQzlCLE1BQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxJQUFJLEVBQUUsQ0FBQztZQUM3QyxNQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssSUFBSSxNQUFNLENBQUM7WUFDL0MsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUFPLElBQUksRUFBRSxDQUFDO1lBRTlDLElBQUksSUFBSSxLQUFLLFFBQVEsSUFBSSxNQUFNLEtBQUssUUFBUSxJQUFJLE1BQU0sS0FBSyxTQUFTLEVBQUU7Z0JBQ2xFLE1BQU0sQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztnQkFDM0MsT0FBTzthQUNWO1lBRUQsSUFBSSxJQUFJLEtBQUssUUFBUSxJQUFJLE1BQU0sS0FBSyxRQUFRLElBQUksS0FBSyxLQUFLLEVBQUUsSUFBSSxLQUFLLENBQUMsV0FBVyxFQUFFO2dCQUMvRSxNQUFNLFNBQVMsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQVMsQ0FBQztnQkFFNUQsU0FBUyxDQUFDLEtBQUssQ0FBQyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQzVDLFNBQVMsQ0FBQyxFQUFFLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUM7Z0JBRXBDLE1BQU0sQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEdBQUcsU0FBUyxDQUFDO2dCQUN6QyxNQUFNLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsRUFBRSxDQUFDO2dCQUVqRCxPQUFPO2FBQ1Y7WUFFRCxJQUFJLEtBQUssQ0FBQyxXQUFXLEVBQUU7Z0JBQ25CLE1BQU0sQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztnQkFDakQsT0FBTzthQUNWO1lBRUQsSUFBSSxLQUFLLENBQUMsS0FBSyxFQUFFO2dCQUNiLE1BQU0sQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRSxDQUFDO2dCQUNsQyxLQUFLLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRTtvQkFDdkIsSUFBRyxDQUFDLElBQUksRUFBRSxFQUFFLElBQUksSUFBSSxFQUFFLFVBQVUsRUFBRSxPQUFPLEVBQUM7d0JBQ3RDLE9BQU87cUJBQ1Y7b0JBQ0QsTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLENBQUM7d0JBQzlCLEVBQUUsRUFBRSxJQUFJLENBQUMsRUFBRTt3QkFDWCxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07d0JBQ25CLFVBQVUsRUFBRSxTQUFTLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztxQkFDL0IsQ0FBQyxDQUFBO2dCQUNoQixDQUFDLENBQUMsQ0FBQztnQkFDSCxPQUFPO2FBQ1Y7WUFFRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRTtnQkFDeEIsTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7Z0JBQ3RELE9BQU87YUFDVjtZQUVELElBQUksS0FBSyxDQUFDLFNBQVMsRUFBRTtnQkFDakIsTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUMvQyxPQUFPO2FBQ1Y7WUFFRCxJQUFJLEtBQUssQ0FBQyxXQUFXLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssRUFBRSxDQUFDLEVBQUc7Z0JBRWxFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxFQUFFO29CQUN0QyxPQUFPLE1BQU0sQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUM7aUJBQ3ZDO2dCQUNELE9BQU87YUFDVjtZQUVELE1BQU0sQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUMvQyxDQUFDLENBQUMsQ0FBQztJQUNQLENBQUM7cUZBN0VRLG9CQUFvQjt1RUFBcEIsb0JBQW9CLFdBQXBCLG9CQUFvQixtQkFGakIsTUFBTTs7U0FFVCxvQkFBb0I7dUZBQXBCLG9CQUFvQjtjQUhoQyxVQUFVO2VBQUM7Z0JBQ1IsVUFBVSxFQUFFLE1BQU07YUFDckIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge2RlZXBDbG9uZSwgUmVjb3JkLCBSZWNvcmRNYXBwZXJ9IGZyb20gJ2NvbW1vbic7XG5pbXBvcnQge0luamVjdGFibGV9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHtpc05pbH0gZnJvbSBcImxvZGFzaC1lc1wiO1xuXG5ASW5qZWN0YWJsZSh7XG4gICAgcHJvdmlkZWRJbjogJ3Jvb3QnXG59KVxuZXhwb3J0IGNsYXNzIEJhc2VTYXZlUmVjb3JkTWFwcGVyIGltcGxlbWVudHMgUmVjb3JkTWFwcGVyIHtcblxuICAgIGdldEtleSgpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gJ2Jhc2UnO1xuICAgIH1cblxuICAgIG1hcChyZWNvcmQ6IFJlY29yZCk6IHZvaWQge1xuXG4gICAgICAgIGlmICghcmVjb3JkLmZpZWxkcyB8fCAhT2JqZWN0LmtleXMocmVjb3JkLmZpZWxkcykubGVuZ3RoKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cblxuICAgICAgICBPYmplY3Qua2V5cyhyZWNvcmQuZmllbGRzKS5mb3JFYWNoKGZpZWxkTmFtZSA9PiB7XG4gICAgICAgICAgICBjb25zdCBmaWVsZCA9IHJlY29yZC5maWVsZHNbZmllbGROYW1lXTtcblxuICAgICAgICAgICAgY29uc3QgdHlwZSA9IGZpZWxkLnR5cGUgfHwgJyc7XG4gICAgICAgICAgICBjb25zdCBzb3VyY2UgPSBmaWVsZC5kZWZpbml0aW9uLnNvdXJjZSB8fCAnJztcbiAgICAgICAgICAgIGNvbnN0IHJuYW1lID0gZmllbGQuZGVmaW5pdGlvbi5ybmFtZSB8fCAnbmFtZSc7XG4gICAgICAgICAgICBjb25zdCBpZE5hbWUgPSBmaWVsZC5kZWZpbml0aW9uLmlkX25hbWUgfHwgJyc7XG5cbiAgICAgICAgICAgIGlmICh0eXBlID09PSAncmVsYXRlJyAmJiBzb3VyY2UgPT09ICdub24tZGInICYmIGlkTmFtZSA9PT0gZmllbGROYW1lKSB7XG4gICAgICAgICAgICAgICAgcmVjb3JkLmF0dHJpYnV0ZXNbZmllbGROYW1lXSA9IGZpZWxkLnZhbHVlO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKHR5cGUgPT09ICdyZWxhdGUnICYmIHNvdXJjZSA9PT0gJ25vbi1kYicgJiYgcm5hbWUgIT09ICcnICYmIGZpZWxkLnZhbHVlT2JqZWN0KSB7XG4gICAgICAgICAgICAgICAgY29uc3QgYXR0cmlidXRlID0gcmVjb3JkLmF0dHJpYnV0ZXNbZmllbGROYW1lXSB8fCB7fSBhcyBhbnk7XG5cbiAgICAgICAgICAgICAgICBhdHRyaWJ1dGVbcm5hbWVdID0gZmllbGQudmFsdWVPYmplY3Rbcm5hbWVdO1xuICAgICAgICAgICAgICAgIGF0dHJpYnV0ZS5pZCA9IGZpZWxkLnZhbHVlT2JqZWN0LmlkO1xuXG4gICAgICAgICAgICAgICAgcmVjb3JkLmF0dHJpYnV0ZXNbZmllbGROYW1lXSA9IGF0dHJpYnV0ZTtcbiAgICAgICAgICAgICAgICByZWNvcmQuYXR0cmlidXRlc1tpZE5hbWVdID0gZmllbGQudmFsdWVPYmplY3QuaWQ7XG5cbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChmaWVsZC52YWx1ZU9iamVjdCkge1xuICAgICAgICAgICAgICAgIHJlY29yZC5hdHRyaWJ1dGVzW2ZpZWxkTmFtZV0gPSBmaWVsZC52YWx1ZU9iamVjdDtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChmaWVsZC5pdGVtcykge1xuICAgICAgICAgICAgICAgIHJlY29yZC5hdHRyaWJ1dGVzW2ZpZWxkTmFtZV0gPSBbXTtcbiAgICAgICAgICAgICAgICBmaWVsZC5pdGVtcy5mb3JFYWNoKGl0ZW0gPT4ge1xuICAgICAgICAgICAgICAgICAgICBpZighaXRlbT8uaWQgJiYgaXRlbT8uYXR0cmlidXRlcz8uZGVsZXRlZCl7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgcmVjb3JkLmF0dHJpYnV0ZXNbZmllbGROYW1lXS5wdXNoKHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlkOiBpdGVtLmlkLFxuICAgICAgICAgICAgICAgICAgICAgICAgbW9kdWxlOiBpdGVtLm1vZHVsZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGF0dHJpYnV0ZXM6IGRlZXBDbG9uZShpdGVtLmF0dHJpYnV0ZXMpXG4gICAgICAgICAgICAgICAgICAgIH0gYXMgUmVjb3JkKVxuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKGZpZWxkLnZhbHVlT2JqZWN0QXJyYXkpIHtcbiAgICAgICAgICAgICAgICByZWNvcmQuYXR0cmlidXRlc1tmaWVsZE5hbWVdID0gZmllbGQudmFsdWVPYmplY3RBcnJheTtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChmaWVsZC52YWx1ZUxpc3QpIHtcbiAgICAgICAgICAgICAgICByZWNvcmQuYXR0cmlidXRlc1tmaWVsZE5hbWVdID0gZmllbGQudmFsdWVMaXN0O1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKGZpZWxkLnZhcmRlZkJhc2VkICYmIChpc05pbChmaWVsZC52YWx1ZSkgfHwgZmllbGQudmFsdWUgPT09ICcnKSApIHtcblxuICAgICAgICAgICAgICAgIGlmICghaXNOaWwocmVjb3JkLmF0dHJpYnV0ZXNbZmllbGROYW1lXSkpIHtcbiAgICAgICAgICAgICAgICAgICAgZGVsZXRlIHJlY29yZC5hdHRyaWJ1dGVzW2ZpZWxkTmFtZV07XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgcmVjb3JkLmF0dHJpYnV0ZXNbZmllbGROYW1lXSA9IGZpZWxkLnZhbHVlO1xuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=