/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from "@angular/core";
import { Subject } from "rxjs";
import { takeUntil } from "rxjs/operators";
import { ListViewStore, } from "../../store/list-view/list-view.store";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { QuickFiltersService } from "../../services/quick-filters.service";
import { ListViewSidebarWidgetService } from "../../services/list-view-sidebar-widget.service";
import { RecordPaginationService } from "../../../record/store/record-pagination/record-pagination.service";
import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/list-view/list-view.store";
import * as i3 from "../../services/quick-filters.service";
import * as i4 from "../../services/list-view-sidebar-widget.service";
import * as i5 from "../../../record/store/record-pagination/record-pagination.service";
import * as i6 from "@angular/common";
import * as i7 from "../list-header/list-header.component";
import * as i8 from "../list-container/list-container.component";
function ListComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "scrm-list-header")(2, "scrm-list-container");
    i0.ɵɵelementEnd();
} }
class ColorService {
    constructor() {
        this.colors = null;
        this.loading = null;
    }
    getColors() {
        if (this.colors)
            return Promise.resolve(this.colors);
        if (this.loading)
            return this.loading;
        // Get the base URL without the hash fragment
        const baseUrl = window.location.origin + window.location.pathname;
        // Remove trailing slash if present
        const cleanBaseUrl = baseUrl.endsWith('/') ? baseUrl.slice(0, -1) : baseUrl;
        this.loading = fetch(`${cleanBaseUrl}/custom/field_colors.php`)
            .then(res => res.json())
            .then(data => {
            this.colors = data;
            return data;
        })
            .catch(error => {
            console.error("Failed to load color mappings:", error);
            return { tagColors: {}, callStatus: {} };
        });
        return this.loading;
    }
    static { this.ɵfac = function ColorService_Factory(t) { return new (t || ColorService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ColorService, factory: ColorService.ɵfac, providedIn: 'root' }); }
}
export { ColorService };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ColorService, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], null, null); })();
class ListComponent {
    constructor(appState, listStore, quickFilters, sidebarWidgetHandler, recordPaginationService, colorService) {
        this.appState = appState;
        this.listStore = listStore;
        this.quickFilters = quickFilters;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.recordPaginationService = recordPaginationService;
        this.colorService = colorService;
        this.destroy$ = new Subject();
        this.TAG_COLORS_LIST = {};
        this.CALL_STATUS_STYLES = {};
        this.vm$ = null;
    }
    ngOnInit() {
        console.log("List component init");
        this.appState.removeAllPrevRoutes();
        this.module = this.appState.getModule();
        this.listSub = this.listStore.init(this.module).subscribe();
        this.vm$ = this.listStore.vm$;
        this.vm$.pipe(takeUntil(this.destroy$)).subscribe(() => {
            // Wait for DOM to render - using a one-time timeout instead of repeatedly polling
            setTimeout(() => {
                this.setupDomObserver();
            }, 300);
        });
    }
    ngAfterViewInit() {
        console.log("list.component.ts ngAfterViewInit");
        // Load colors once and cache them
        this.loadColors().then(() => {
            // Only apply styles if we have colors loaded
            if (this.TAG_COLORS_LIST && Object.keys(this.TAG_COLORS_LIST).length > 0) {
                this.injectListTagColors();
                // Only call injectCallStatusDotList if we're in the contacts module
                if (this.module === 'contacts') {
                    this.injectCallStatusDotList();
                }
            }
        });
    }
    ngOnDestroy() {
        if (this.listSub) {
            this.listSub.unsubscribe();
        }
        // Clean up the observer if it exists
        if (this.domObserver) {
            this.domObserver.disconnect();
        }
        // Signal all subscriptions to complete
        this.destroy$.next();
        this.destroy$.complete();
        this.updateListLocalStorage();
        this.quickFilters.destroy();
        this.sidebarWidgetHandler.destroy();
        this.listStore.destroy();
    }
    setupDomObserver() {
        // Clean up any existing observer
        if (this.domObserver) {
            this.domObserver.disconnect();
        }
        // Only set up the observer for contacts module
        if (this.module !== 'contacts') {
            return;
        }
        const listTable = document.querySelector(".list-view-table") || document.body;
        // Debounce the observer to prevent excessive calls
        let timeoutId;
        this.domObserver = new MutationObserver(() => {
            // Clear existing timeout
            if (timeoutId) {
                clearTimeout(timeoutId);
            }
            // Debounce the processing
            timeoutId = setTimeout(() => {
                this.processStyling();
            }, 100);
        });
        this.domObserver.observe(listTable, { childList: true, subtree: true });
    }
    processStyling() {
        // Only process if we have colors loaded
        if (!this.TAG_COLORS_LIST || Object.keys(this.TAG_COLORS_LIST).length === 0) {
            return;
        }
        this.injectListTagColors();
        this.injectCallStatusDotList();
    }
    updateListLocalStorage() {
        this.recordPaginationService.updateRecordListLocalStorage(this.listStore.recordList.records, this.listStore.recordList.pagination);
    }
    injectCallStatusDotList() {
        // Check if the module is contacts, if not return early
        if (this.module !== 'contacts') {
            return;
        }
        // Use more specific selector to reduce DOM queries
        const callStatusEls = document.querySelectorAll(".field-name-call_status_c scrm-dropdownenum-detail:not(.styled)");
        if (callStatusEls.length === 0) {
            return;
        }
        // Batch process elements for better performance
        const fragment = document.createDocumentFragment();
        callStatusEls.forEach((el) => {
            const rawText = el.textContent?.trim() || "";
            const cleanVal = rawText.toLowerCase().replace(/\s+/g, "");
            const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
            if (styleInfo) {
                // Create span element once
                const span = document.createElement('span');
                span.className = 'call-status-pill';
                span.textContent = `${styleInfo.emoji} ${rawText}`;
                // Apply styles efficiently
                Object.assign(span.style, {
                    backgroundColor: styleInfo.color,
                    color: "#fff",
                    padding: "2px 10px",
                    borderRadius: "20px",
                    fontWeight: "600",
                    display: "inline-block",
                    textTransform: "uppercase",
                    fontSize: "12px",
                    letterSpacing: "0.5px"
                });
                // Clear and append
                el.innerHTML = '';
                el.appendChild(span);
                // Mark as styled to prevent reprocessing
                el.classList.add('styled');
            }
        });
    }
    injectListTagColors() {
        // Only process unstyled elements
        const tagLists = document.querySelectorAll(".field-name-tag_c scrm-multienum-detail li:not(.tag-styled)");
        if (tagLists.length === 0) {
            return;
        }
        tagLists.forEach((el) => {
            const label = el.textContent?.trim().toLowerCase();
            this.applyFlatTagStyleList(el, label);
            // Mark as styled to prevent reprocessing
            el.classList.add('tag-styled');
        });
    }
    async loadColors() {
        try {
            const data = await this.colorService.getColors();
            this.TAG_COLORS_LIST = data.tagColors;
            this.CALL_STATUS_STYLES = data.callStatus;
        }
        catch (error) {
            console.error("Failed to load color mappings:", error);
        }
    }
    applyFlatTagStyleList(el, label) {
        const color = this.TAG_COLORS_LIST[label.toLowerCase()];
        if (!color)
            return;
        // Apply styles efficiently in one operation
        Object.assign(el.style, {
            backgroundColor: color,
            color: "white",
            fontSize: "12px",
            fontWeight: "bold",
            padding: "2px 8px",
            borderRadius: "12px",
            display: "inline-block",
            margin: "2px"
        });
    }
    static { this.ɵfac = function ListComponent_Factory(t) { return new (t || ListComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.ListViewStore), i0.ɵɵdirectiveInject(i3.QuickFiltersService), i0.ɵɵdirectiveInject(i4.ListViewSidebarWidgetService), i0.ɵɵdirectiveInject(i5.RecordPaginationService), i0.ɵɵdirectiveInject(ColorService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ListComponent, selectors: [["scrm-list"]], features: [i0.ɵɵProvidersFeature([ListViewStore, QuickFiltersService, ListViewSidebarWidgetService])], decls: 2, vars: 3, consts: [["class", "list-view", 4, "ngIf"], [1, "list-view"]], template: function ListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ListComponent_div_0_Template, 3, 0, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i6.NgIf, i7.ListHeaderComponent, i8.ListContainerComponent, i6.AsyncPipe], encapsulation: 2 }); }
}
export { ListComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ListComponent, [{
        type: Component,
        args: [{ selector: "scrm-list", providers: [ListViewStore, QuickFiltersService, ListViewSidebarWidgetService], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start List View Section -->\n<div class=\"list-view\" *ngIf=\"(vm$ | async) as vm\">\n    <scrm-list-header></scrm-list-header>\n    <scrm-list-container></scrm-list-container>\n</div>\n<!-- End List View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.ListViewStore }, { type: i3.QuickFiltersService }, { type: i4.ListViewSidebarWidgetService }, { type: i5.RecordPaginationService }, { type: ColorService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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