import { Injectable } from '@angular/core';
import { ActionLogicHandler } from '../../../../services/actions/action-logic-handler';
import { ActiveFieldsChecker } from "../../../../services/condition-operators/active-fields-checker.service";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/condition-operators/active-fields-checker.service";
class RecordActionDisplayTypeLogic extends ActionLogicHandler {
    constructor(activeFieldsChecker) {
        super();
        this.activeFieldsChecker = activeFieldsChecker;
        this.key = 'displayType';
        this.modes = ['edit', 'detail', 'list', 'create', 'massupdate', 'filter'];
    }
    runAll(displayLogic, data) {
        let toDisplay = true;
        const validModeLogic = Object.values(displayLogic).filter(logic => {
            const allowedModes = logic.modes ?? [];
            return !!(allowedModes.length && allowedModes.includes(data.store.getMode()));
        });
        if (!validModeLogic || !validModeLogic.length) {
            return toDisplay;
        }
        let defaultDisplay = data?.action?.display ?? 'show';
        let targetDisplay = 'hide';
        if (defaultDisplay === 'hide') {
            targetDisplay = 'show';
        }
        const isActive = validModeLogic.some(logic => this.run(data, logic));
        if (isActive) {
            defaultDisplay = targetDisplay;
        }
        toDisplay = (defaultDisplay === 'show');
        return toDisplay;
    }
    run(data, logic) {
        const record = data.store.recordStore.getStaging();
        if (!record || !logic) {
            return true;
        }
        const activeOnFields = (logic.params && logic.params.activeOnFields) || {};
        const relatedFields = Object.keys(activeOnFields);
        const activeOnAttributes = (logic.params && logic.params.activeOnAttributes) || {};
        const relatedAttributesFields = Object.keys(activeOnAttributes);
        if (!relatedFields.length && !relatedAttributesFields.length) {
            return true;
        }
        return this.activeFieldsChecker.isActive(relatedFields, record, activeOnFields, relatedAttributesFields, activeOnAttributes);
    }
    static { this.ɵfac = function RecordActionDisplayTypeLogic_Factory(t) { return new (t || RecordActionDisplayTypeLogic)(i0.ɵɵinject(i1.ActiveFieldsChecker)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordActionDisplayTypeLogic, factory: RecordActionDisplayTypeLogic.ɵfac, providedIn: 'root' }); }
}
export { RecordActionDisplayTypeLogic };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordActionDisplayTypeLogic, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.ActiveFieldsChecker }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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