/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { ActionHandler } from 'common';
export class RecordActionHandler extends ActionHandler {
    checkRecordAccess(data, defaultAcls = []) {
        const record = data.store.recordStore.getBaseRecord();
        const acls = record.acls ?? [];
        if (!acls || !acls.length) {
            return false;
        }
        const action = data.action ?? null;
        return this.checkAccess(action, acls, defaultAcls);
    }
    /**
     * Navigate back
     * @param navigation
     * @param params
     * @param id
     * @param moduleName
     * @param record
     */
    navigateBack(navigation, params, id, moduleName, record) {
        let returnModule = navigation.getReturnModule(params);
        let returnAction = navigation.getReturnAction(params);
        let returnId = navigation.getReturnId(params);
        if (id === returnId) {
            return;
        }
        if (returnModule === moduleName &&
            returnAction === 'record' &&
            returnId !== id) {
            return;
        }
        if (!returnModule || !returnAction) {
            return;
        }
        navigation.navigateBack(record, moduleName, params);
    }
    navigateBackToDetail(navigation, router, recordPaginationService, id, moduleName) {
        const nextRoute = navigation.getRecordRouterLink(moduleName, id);
        router.navigate([nextRoute], { queryParams: { offset: recordPaginationService.getOffsetFromUrl() } });
    }
}
//# sourceMappingURL=data:application/json;base64,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