import { ValidatorInterface } from './validator.Interface';
import { MapEntry, OverridableMap, Record, StringMap, StringMatrix, ViewFieldDefinition } from 'common';
import { AsyncValidatorFn, ValidatorFn } from '@angular/forms';
import { AsyncValidatorInterface } from './aync-validator.Interface';
import { RequiredValidator } from './validators/required.validator';
import { CurrencyValidator } from './validators/currency.validator';
import { DateValidator } from './validators/date.validator';
import { DateTimeValidator } from './validators/datetime.validator';
import { FloatValidator } from './validators/float.validator';
import { IntValidator } from './validators/int.validator';
import { EmailValidator } from './validators/email.validator';
import { PhoneValidator } from './validators/phone.validator';
import { RangeValidator } from './validators/range.validator';
import { PrimaryEmailValidator } from './validators/primary-email.validator';
import { DuplicateEmailValidator } from './validators/duplicate-email.validator';
import { LineItemsRequiredValidator } from "./validators/line-items-required.validator";
import * as i0 from "@angular/core";
export interface ValidationManagerInterface {
    registerSaveValidator(module: string, key: string, validator: ValidatorInterface): void;
    registerFilterValidator(module: string, key: string, validator: ValidatorInterface): void;
    excludeSaveValidator(module: string, key: string): void;
    excludeFilterValidator(module: string, key: string): void;
    registerAsyncSaveValidator(module: string, key: string, validator: AsyncValidatorInterface): void;
    excludeAsyncSaveValidator(module: string, key: string): void;
    getSaveValidations(module: string, viewField: ViewFieldDefinition, record: Record): ValidatorFn[];
    getFilterValidations(module: string, viewField: ViewFieldDefinition, record: Record): ValidatorFn[];
    getAsyncSaveValidations(module: string, viewField: ViewFieldDefinition, record: Record): AsyncValidatorFn[];
}
export declare class ValidationManager implements ValidationManagerInterface {
    protected requiredValidator: RequiredValidator;
    protected rangeValidator: RangeValidator;
    protected currencyValidator: CurrencyValidator;
    protected dateValidator: DateValidator;
    protected datetimeValidator: DateTimeValidator;
    protected emailValidator: EmailValidator;
    protected floatValidator: FloatValidator;
    protected intValidator: IntValidator;
    protected phoneValidator: PhoneValidator;
    protected primaryEmailValidator: PrimaryEmailValidator;
    protected duplicateEmailValidator: DuplicateEmailValidator;
    protected lineItemsRequiredValidator: LineItemsRequiredValidator;
    protected saveValidators: OverridableMap<ValidatorInterface>;
    protected itemFormArraySaveValidators: OverridableMap<ValidatorInterface>;
    protected asyncSaveValidators: OverridableMap<AsyncValidatorInterface>;
    protected filterValidators: OverridableMap<ValidatorInterface>;
    protected filterFieldExclusion: StringMatrix;
    protected saveFieldExclusions: StringMatrix;
    constructor(requiredValidator: RequiredValidator, rangeValidator: RangeValidator, currencyValidator: CurrencyValidator, dateValidator: DateValidator, datetimeValidator: DateTimeValidator, emailValidator: EmailValidator, floatValidator: FloatValidator, intValidator: IntValidator, phoneValidator: PhoneValidator, primaryEmailValidator: PrimaryEmailValidator, duplicateEmailValidator: DuplicateEmailValidator, lineItemsRequiredValidator: LineItemsRequiredValidator);
    registerFieldSaveValidator(module: string, type: string, field: string, validator: ValidatorInterface): void;
    registerSaveValidator(module: string, type: string, validator: ValidatorInterface): void;
    registerFieldFilterValidator(module: string, type: string, field: string, validator: ValidatorInterface): void;
    registerFilterValidator(module: string, type: string, validator: ValidatorInterface): void;
    excludeFieldSaveValidator(module: string, type: string, field: string): void;
    excludeSaveValidator(module: string, type: string): void;
    excludeFieldFilterValidator(module: string, type: string, field: string): void;
    excludeFilterValidator(module: string, type: string): void;
    registerAsyncSaveValidator(module: string, type: string, validator: AsyncValidatorInterface): void;
    excludeAsyncSaveValidator(module: string, type: string): void;
    getSaveValidations(module: string, viewField: ViewFieldDefinition, record: Record): ValidatorFn[];
    getItemFormArraySaveValidations(module: string, viewField: ViewFieldDefinition, record: Record): ValidatorFn[];
    getFilterValidations(module: string, viewField: ViewFieldDefinition, record: Record): ValidatorFn[];
    getAsyncSaveValidations(module: string, viewField: ViewFieldDefinition, record: Record): AsyncValidatorFn[];
    getKey(type: string, field: string): string;
    protected parseType(key: string): string;
    protected getExclusions(module: string, exclusionMap: StringMatrix): StringMap;
    protected filterValidations(entries: MapEntry<ValidatorInterface>, fieldExclusions: StringMap, record: Record, viewField: ViewFieldDefinition): ValidatorFn[];
    static ɵfac: i0.ɵɵFactoryDeclaration<ValidationManager, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ValidationManager>;
}
//# sourceMappingURL=validation.manager.d.ts.map