/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
export class OverridableMap {
    constructor() {
        this.map = {
            default: {
                values: {},
                exclude: []
            }
        };
    }
    init(entryMap) {
        Object.keys(entryMap).forEach(group => {
            if (entryMap[group].values) {
                Object.keys(entryMap[group].values).forEach(key => {
                    this.addEntry(group, key, entryMap[group].values[key]);
                });
            }
            if (entryMap[group].exclude) {
                entryMap[group].exclude.forEach(excluded => this.excludeEntry(group, excluded));
            }
        });
    }
    addEntry(group, key, value) {
        if (!(group in this.map)) {
            this.map[group] = {
                values: {},
                exclude: []
            };
        }
        this.map[group].values[key] = value;
    }
    excludeEntry(group, key) {
        if (!(group in this.map)) {
            this.map[group] = {
                values: {},
                exclude: []
            };
        }
        this.map[group].exclude.push(key);
    }
    getGroupEntries(group) {
        const values = {};
        const allValues = { ...this.map.default.values };
        let groupEntry = {
            values: {},
            exclude: []
        };
        if (group in this.map) {
            groupEntry = this.map[group];
            groupEntry.values = groupEntry.values || {};
            groupEntry.exclude = groupEntry.exclude || [];
        }
        Object.keys(groupEntry.values).forEach(key => {
            allValues[key] = groupEntry.values[key];
        });
        Object.keys(allValues).forEach(key => {
            if (this.map.default.exclude.includes(key)) {
                return;
            }
            if (groupEntry.exclude.includes(key)) {
                return;
            }
            values[key] = allValues[key];
        });
        return values;
    }
}
//# sourceMappingURL=data:application/json;base64,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