/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, Input } from '@angular/core';
import { BreakpointObserver } from '@angular/cdk/layout';
import { BaseFieldGridComponent } from '../field-grid/base-field-grid.component';
import * as i0 from "@angular/core";
import * as i1 from "@angular/cdk/layout";
import * as i2 from "@angular/common";
import * as i3 from "../../fields/field.component";
import * as i4 from "../image/image.component";
import * as i5 from "../action-group-menu/action-group-menu.component";
function FieldLayoutComponent_div_1_div_1_ng_container_1_ng_container_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "span", 10);
    i0.ɵɵtext(2, "*");
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} }
function FieldLayoutComponent_div_1_div_1_ng_container_1_ng_container_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div");
    i0.ɵɵelement(2, "scrm-action-group-menu", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const col_r4 = i0.ɵɵnextContext(2).$implicit;
    let tmp_1_0;
    let tmp_2_0;
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("config", col_r4.adaptor)("buttonGroupClass", (tmp_1_0 = col_r4.fieldActions == null ? null : col_r4.fieldActions.containerKlass) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "")("klass", (tmp_2_0 = col_r4.fieldActions == null ? null : col_r4.fieldActions.klass) !== null && tmp_2_0 !== undefined ? tmp_2_0 : "");
} }
function FieldLayoutComponent_div_1_div_1_ng_container_1_button_13_Template(rf, ctx) { if (rf & 1) {
    const _r16 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 12);
    i0.ɵɵlistener("click", function FieldLayoutComponent_div_1_div_1_ng_container_1_button_13_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r16); const ctx_r15 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r15.dataSource.getEditAction()); });
    i0.ɵɵelement(1, "scrm-image", 13);
    i0.ɵɵelementEnd();
} }
const _c0 = function () { return ["edit", "create"]; };
const _c1 = function (a0) { return { "align-items-center": a0 }; };
function FieldLayoutComponent_div_1_div_1_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 5)(2, "strong")(3, "label", 1);
    i0.ɵɵtext(4);
    i0.ɵɵpipe(5, "uppercase");
    i0.ɵɵelementEnd();
    i0.ɵɵtext(6, ": ");
    i0.ɵɵtemplate(7, FieldLayoutComponent_div_1_div_1_ng_container_1_ng_container_7_Template, 3, 0, "ng-container", 3);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(8, "div", 6)(9, "div", 7);
    i0.ɵɵelement(10, "scrm-field", 8);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(11, FieldLayoutComponent_div_1_div_1_ng_container_1_ng_container_11_Template, 3, 3, "ng-container", 3);
    i0.ɵɵelementStart(12, "div");
    i0.ɵɵtemplate(13, FieldLayoutComponent_div_1_div_1_ng_container_1_button_13_Template, 2, 0, "button", 9);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const col_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r6 = i0.ɵɵnextContext(2);
    let tmp_9_0;
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngClass", ctx_r6.labelClass);
    i0.ɵɵadvance(1);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind1(5, 11, col_r4.field.label));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", col_r4.field.definition.required && i0.ɵɵpureFunction0(13, _c0).includes(ctx_r6.config.mode));
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(14, _c1, (col_r4 == null ? null : col_r4.fieldActions) && (col_r4 == null ? null : col_r4.fieldActions == null ? null : col_r4.fieldActions.position) === "inline"));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("type", col_r4.field.type)("mode", ctx_r6.config.mode)("klass", ctx_r6.inputClass)("field", col_r4.field)("record", ctx_r6.record);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", (col_r4 == null ? null : col_r4.fieldActions) && ((tmp_9_0 = col_r4 == null ? null : col_r4.fieldActions == null ? null : col_r4.fieldActions.position) !== null && tmp_9_0 !== undefined ? tmp_9_0 : "inline") === "inline");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", col_r4.field.definition.inline_edit !== false && !col_r4.field.readonly && !col_r4.field.definition.readonly && ctx_r6.dataSource.inlineEdit && ctx_r6.config.mode === "detail");
} }
function FieldLayoutComponent_div_1_div_1_ng_container_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelement(1, "scrm-action-group-menu", 11);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const col_r4 = i0.ɵɵnextContext().$implicit;
    let tmp_1_0;
    let tmp_2_0;
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("config", col_r4.adaptor)("buttonGroupClass", (tmp_1_0 = col_r4.fieldActions == null ? null : col_r4.fieldActions.containerKlass) !== null && tmp_1_0 !== undefined ? tmp_1_0 : "")("klass", (tmp_2_0 = col_r4.fieldActions == null ? null : col_r4.fieldActions.klass) !== null && tmp_2_0 !== undefined ? tmp_2_0 : "");
} }
function FieldLayoutComponent_div_1_div_1_ng_container_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵprojection(1);
    i0.ɵɵelementContainerEnd();
} }
function FieldLayoutComponent_div_1_div_1_ng_container_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵprojection(1, 1);
    i0.ɵɵelementContainerEnd();
} }
function FieldLayoutComponent_div_1_div_1_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 14);
} }
function FieldLayoutComponent_div_1_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, FieldLayoutComponent_div_1_div_1_ng_container_1_Template, 14, 16, "ng-container", 3);
    i0.ɵɵtemplate(2, FieldLayoutComponent_div_1_div_1_ng_container_2_Template, 2, 3, "ng-container", 3);
    i0.ɵɵtemplate(3, FieldLayoutComponent_div_1_div_1_ng_container_3_Template, 2, 0, "ng-container", 3);
    i0.ɵɵtemplate(4, FieldLayoutComponent_div_1_div_1_ng_container_4_Template, 2, 0, "ng-container", 3);
    i0.ɵɵtemplate(5, FieldLayoutComponent_div_1_div_1_div_5_Template, 1, 0, "div", 4);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const col_r4 = ctx.$implicit;
    const colNumber_r5 = ctx.index;
    const ctx_r19 = i0.ɵɵnextContext();
    const row_r1 = ctx_r19.$implicit;
    const i_r2 = ctx_r19.index;
    const ctx_r3 = i0.ɵɵnextContext();
    let tmp_3_0;
    i0.ɵɵclassProp("field-column-bordered", row_r1.cols.length > 1 && colNumber_r5 < row_r1.cols.length - 1);
    i0.ɵɵproperty("ngClass", ctx_r3.colClass);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", col_r4.field && col_r4.field.display !== "none");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", (col_r4 == null ? null : col_r4.fieldActions) && ((tmp_3_0 = col_r4 == null ? null : col_r4.fieldActions == null ? null : col_r4.fieldActions.position) !== null && tmp_3_0 !== undefined ? tmp_3_0 : "inline") === "vertical");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", col_r4.actionSlot);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", col_r4.specialSlot);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", col_r4.field && (col_r4.field == null ? null : col_r4.field.display) !== "none" && i_r2 < ctx_r3.fieldGrid.length - 1);
} }
function FieldLayoutComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, FieldLayoutComponent_div_1_div_1_Template, 6, 8, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const row_r1 = ctx.$implicit;
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", ctx_r0.rowClass);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngForOf", row_r1.cols);
} }
const _c2 = [[["", "field-grid-actions", ""]], [["", "field-grid-special", ""]]];
const _c3 = ["[field-grid-actions]", "[field-grid-special]"];
class FieldLayoutComponent extends BaseFieldGridComponent {
    constructor(breakpointObserver) {
        super(breakpointObserver);
        this.breakpointObserver = breakpointObserver;
        this.baseColClass = {
            col: true,
            'form-group': true,
            'm-1': false,
            'm-0': true,
            'pl-3': true,
            'pb-2': true,
            'pr-3': true,
            'd-flex': true,
            'flex-column': true,
            'justify-content-between': true
        };
        this.baseRowClass = {
            'form-row': true,
            'align-items-stretch': true
        };
    }
    ngOnInit() {
        this.subscriptions.push(this.dataSource.getConfig().subscribe(config => {
            this.config = { ...config };
        }));
        this.subscriptions.push(this.dataSource.getLayout().subscribe(layout => {
            this.layout = { ...layout };
        }));
        this.subscriptions.push(this.dataSource.getFields().subscribe(fields => {
            this.fields = { ...fields };
        }));
        this.subscriptions.push(this.dataSource.getRecord().subscribe(record => {
            this.record = { ...record };
        }));
        super.ngOnInit();
    }
    buildGrid() {
        const grid = [];
        if (!this.fields || Object.keys(this.fields).length === 0) {
            this.fieldGrid = [];
            return;
        }
        this.layout.rows.forEach(layoutRow => {
            let row = {
                cols: []
            };
            layoutRow.cols.forEach((layoutCol, colIndex) => {
                const fieldName = layoutCol.name;
                const field = this.fields[fieldName] || null;
                const fieldActions = layoutCol.fieldActions || null;
                const adaptor = layoutCol.adaptor ?? null;
                if (!field) {
                    row.cols.push({});
                    return;
                }
                row.cols.push({
                    field,
                    fieldActions,
                    adaptor
                });
                if (this.colNumber === 1 && colIndex < layoutRow.cols.length - 1) {
                    grid.push(row);
                    row = {
                        cols: []
                    };
                }
            });
            if (row.cols.length < this.colNumber) {
                this.fillRow(row);
            }
            grid.push(row);
        });
        this.addSpecialSlots(grid);
        this.fieldGrid = grid;
    }
    get colNumber() {
        const size = this.sizeMap[this.currentSize];
        if (size === 1) {
            return 1;
        }
        return this.config.maxColumns;
    }
    static { this.ɵfac = function FieldLayoutComponent_Factory(t) { return new (t || FieldLayoutComponent)(i0.ɵɵdirectiveInject(i1.BreakpointObserver)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldLayoutComponent, selectors: [["scrm-field-layout"]], inputs: { dataSource: "dataSource" }, features: [i0.ɵɵInheritDefinitionFeature], ngContentSelectors: _c3, decls: 2, vars: 4, consts: [[3, "ngClass", 4, "ngFor", "ngForOf"], [3, "ngClass"], [3, "field-column-bordered", "ngClass", 4, "ngFor", "ngForOf"], [4, "ngIf"], ["class", "field-separation mt-2", 4, "ngIf"], [1, "label-container"], [1, "d-flex", "flex-grow-1", 3, "ngClass"], [1, "flex-grow-1", "text-break"], [3, "type", "mode", "klass", "field", "record"], ["type", "button", "class", "record-action-button", 3, "click", 4, "ngIf"], [1, "required"], [3, "config", "buttonGroupClass", "klass"], ["type", "button", 1, "record-action-button", 3, "click"], ["image", "pencil", 1, "sicon"], [1, "field-separation", "mt-2"]], template: function FieldLayoutComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵprojectionDef(_c2);
            i0.ɵɵelementStart(0, "form");
            i0.ɵɵtemplate(1, FieldLayoutComponent_div_1_Template, 2, 2, "div", 0);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵclassMapInterpolate1("field-layout ", ctx.config.mode, "");
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("ngForOf", ctx.fieldGrid);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i3.FieldComponent, i4.ImageComponent, i5.ActionGroupMenuComponent, i2.UpperCasePipe], encapsulation: 2 }); }
}
export { FieldLayoutComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldLayoutComponent, [{
        type: Component,
        args: [{ selector: 'scrm-field-layout', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<form class=\"field-layout {{config.mode}}\">\n    <div [ngClass]=\"rowClass\" *ngFor=\"let row of fieldGrid; index as i\">\n\n        <div *ngFor=\"let col of row.cols; index as colNumber\"\n             [class.field-column-bordered]=\"row.cols.length > 1 && colNumber < row.cols.length - 1\"\n             [ngClass]=\"colClass\">\n\n            <ng-container *ngIf=\"col.field && col.field.display !== 'none'\">\n                <div class=\"label-container\">\n                    <strong>\n                        <label [ngClass]=\"labelClass\">{{col.field.label | uppercase}}</label>:\n                        <ng-container\n                            *ngIf=\"col.field.definition.required && (['edit', 'create'].includes(config.mode))\">\n                            <span class=\"required\">*</span>\n                        </ng-container>\n                    </strong>\n                </div>\n                <div class=\"d-flex flex-grow-1\"\n                    [ngClass]=\"{ 'align-items-center': (col?.fieldActions && col?.fieldActions?.position === 'inline') }\">\n                    <div class=\"flex-grow-1 text-break\">\n                        <scrm-field [type]=\"col.field.type\"\n                                    [mode]=\"config.mode\"\n                                    [klass]=\"inputClass\"\n                                    [field]=\"col.field\"\n                                    [record]=\"record\">\n                        </scrm-field>\n                    </div>\n\n                    <ng-container *ngIf=\"col?.fieldActions && ((col?.fieldActions?.position ?? 'inline') === 'inline')\">\n                        <div>\n                            <scrm-action-group-menu\n                                [config]=\"col.adaptor\"\n                                [buttonGroupClass] = \"col.fieldActions?.containerKlass ?? ''\"\n                                [klass] = \"col.fieldActions?.klass ?? ''\"\n                            >\n                            </scrm-action-group-menu>\n                        </div>\n                    </ng-container>\n\n                    <div>\n                        <button type=\"button\" class=\"record-action-button\"\n                                (click)=\"this.dataSource.getEditAction()\"\n                                *ngIf=\"col.field.definition.inline_edit !== false && !col.field.readonly && !col.field.definition.readonly && this.dataSource.inlineEdit && config.mode === 'detail'\">\n                            <scrm-image class=\"sicon\" image=\"pencil\"></scrm-image>\n                        </button>\n                    </div>\n                </div>\n            </ng-container>\n\n            <ng-container *ngIf=\"col?.fieldActions && ((col?.fieldActions?.position ?? 'inline' ) === 'vertical')\">\n                <scrm-action-group-menu\n                    [config]=\"col.adaptor\"\n                    [buttonGroupClass]=\"col.fieldActions?.containerKlass ?? ''\"\n                    [klass] = \"col.fieldActions?.klass ?? ''\"\n                >\n                </scrm-action-group-menu>\n            </ng-container>\n\n            <ng-container *ngIf=\"col.actionSlot\">\n                <ng-content select=\"[field-grid-actions]\"></ng-content>\n            </ng-container>\n\n            <ng-container *ngIf=\"col.specialSlot\">\n                <ng-content select=\"[field-grid-special]\"></ng-content>\n            </ng-container>\n\n            <div *ngIf=\"col.field && col.field?.display !== 'none' && i < fieldGrid.length - 1\"\n                 class=\"field-separation mt-2\">\n            </div>\n        </div>\n    </div>\n</form>\n" }]
    }], function () { return [{ type: i1.BreakpointObserver }]; }, { dataSource: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmllbGQtbGF5b3V0LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi9jb21wb25lbnRzL2ZpZWxkLWxheW91dC9maWVsZC1sYXlvdXQuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vY29yZS9hcHAvY29yZS9zcmMvbGliL2NvbXBvbmVudHMvZmllbGQtbGF5b3V0L2ZpZWxkLWxheW91dC5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBd0JHO0FBRUgsT0FBTyxFQUFDLFNBQVMsRUFBRSxLQUFLLEVBQUMsTUFBTSxlQUFlLENBQUM7QUFFL0MsT0FBTyxFQUFDLGtCQUFrQixFQUFDLE1BQU0scUJBQXFCLENBQUM7QUFFdkQsT0FBTyxFQUFDLHNCQUFzQixFQUFDLE1BQU0seUNBQXlDLENBQUM7Ozs7Ozs7O0lDUXZELDZCQUN3RjtJQUNwRixnQ0FBdUI7SUFBQSxpQkFBQztJQUFBLGlCQUFPO0lBQ25DLDBCQUFlOzs7SUFjbkIsNkJBQW9HO0lBQ2hHLDJCQUFLO0lBQ0QsNkNBS3lCO0lBQzdCLGlCQUFNO0lBQ1YsMEJBQWU7Ozs7O0lBTkgsZUFBc0I7SUFBdEIsdUNBQXNCLDBKQUFBLHNJQUFBOzs7O0lBUzlCLGtDQUU4SztJQUR0SyxtTUFBUyxlQUFBLGtDQUErQixDQUFBLElBQUM7SUFFN0MsaUNBQXNEO0lBQzFELGlCQUFTOzs7OztJQXJDckIsNkJBQWdFO0lBQzVELDhCQUE2QixhQUFBLGVBQUE7SUFFUyxZQUErQjs7SUFBQSxpQkFBUTtJQUFBLGtCQUNyRTtJQUFBLGtIQUdlO0lBQ25CLGlCQUFTLEVBQUE7SUFFYiw4QkFDMEcsYUFBQTtJQUVsRyxpQ0FLYTtJQUNqQixpQkFBTTtJQUVOLG9IQVNlO0lBRWYsNEJBQUs7SUFDRCx3R0FJUztJQUNiLGlCQUFNLEVBQUE7SUFFZCwwQkFBZTs7Ozs7SUFyQ0ksZUFBc0I7SUFBdEIsMkNBQXNCO0lBQUMsZUFBK0I7SUFBL0IsK0RBQStCO0lBRXhELGVBQWlGO0lBQWpGLG1IQUFpRjtJQU0xRixlQUFxRztJQUFyRyxnTkFBcUc7SUFFckYsZUFBdUI7SUFBdkIsd0NBQXVCLDRCQUFBLDRCQUFBLHVCQUFBLHlCQUFBO0lBUXhCLGVBQW1GO0lBQW5GLG1QQUFtRjtJQWNyRixlQUFtSztJQUFuSyxzTUFBbUs7OztJQU94TCw2QkFBdUc7SUFDbkcsNkNBS3lCO0lBQzdCLDBCQUFlOzs7OztJQUxQLGVBQXNCO0lBQXRCLHVDQUFzQiwwSkFBQSxzSUFBQTs7O0lBTzlCLDZCQUFxQztJQUNqQyxrQkFBdUQ7SUFDM0QsMEJBQWU7OztJQUVmLDZCQUFzQztJQUNsQyxxQkFBdUQ7SUFDM0QsMEJBQWU7OztJQUVmLDBCQUVNOzs7SUFqRVYsOEJBRTBCO0lBRXRCLHFHQXdDZTtJQUVmLG1HQU9lO0lBRWYsbUdBRWU7SUFFZixtR0FFZTtJQUVmLGlGQUVNO0lBQ1YsaUJBQU07Ozs7Ozs7OztJQWpFRCx3R0FBc0Y7SUFDdEYseUNBQW9CO0lBRU4sZUFBK0M7SUFBL0Msc0VBQStDO0lBMEMvQyxlQUFzRjtJQUF0RixxUEFBc0Y7SUFTdEYsZUFBb0I7SUFBcEIsd0NBQW9CO0lBSXBCLGVBQXFCO0lBQXJCLHlDQUFxQjtJQUk5QixlQUE0RTtJQUE1RSw0SUFBNEU7OztJQWpFMUYsOEJBQW9FO0lBRWhFLDJFQWtFTTtJQUNWLGlCQUFNOzs7O0lBckVELHlDQUFvQjtJQUVBLGVBQWE7SUFBYixxQ0FBYTs7OztBREcxQyxNQUlhLG9CQUFxQixTQUFRLHNCQUFzQjtJQTBCNUQsWUFBc0Isa0JBQXNDO1FBQ3hELEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBRFIsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFvQjtRQWxCNUQsaUJBQVksR0FBRztZQUNYLEdBQUcsRUFBRSxJQUFJO1lBQ1QsWUFBWSxFQUFFLElBQUk7WUFDbEIsS0FBSyxFQUFFLEtBQUs7WUFDWixLQUFLLEVBQUUsSUFBSTtZQUNYLE1BQU0sRUFBRSxJQUFJO1lBQ1osTUFBTSxFQUFFLElBQUk7WUFDWixNQUFNLEVBQUUsSUFBSTtZQUNaLFFBQVEsRUFBRSxJQUFJO1lBQ2QsYUFBYSxFQUFFLElBQUk7WUFDbkIseUJBQXlCLEVBQUUsSUFBSTtTQUNMLENBQUM7UUFFL0IsaUJBQVksR0FBRztZQUNYLFVBQVUsRUFBRSxJQUFJO1lBQ2hCLHFCQUFxQixFQUFFLElBQUk7U0FDRCxDQUFDO0lBSS9CLENBQUM7SUFFRCxRQUFRO1FBRUosSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLEVBQUU7WUFDbkUsSUFBSSxDQUFDLE1BQU0sR0FBRyxFQUFDLEdBQUcsTUFBTSxFQUFDLENBQUM7UUFDOUIsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNKLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxFQUFFLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQ25FLElBQUksQ0FBQyxNQUFNLEdBQUcsRUFBQyxHQUFHLE1BQU0sRUFBQyxDQUFDO1FBQzlCLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDSixJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUNuRSxJQUFJLENBQUMsTUFBTSxHQUFHLEVBQUMsR0FBRyxNQUFNLEVBQUMsQ0FBQztRQUM5QixDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ0osSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLEVBQUU7WUFDbkUsSUFBSSxDQUFDLE1BQU0sR0FBRyxFQUFDLEdBQUcsTUFBTSxFQUFDLENBQUM7UUFDOUIsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUVKLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUNyQixDQUFDO0lBRUQsU0FBUztRQUNMLE1BQU0sSUFBSSxHQUFtQixFQUFFLENBQUM7UUFFaEMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUN2RCxJQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQztZQUNwQixPQUFPO1NBQ1Y7UUFFRCxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEVBQUU7WUFDakMsSUFBSSxHQUFHLEdBQUc7Z0JBQ04sSUFBSSxFQUFFLEVBQUU7YUFDSyxDQUFDO1lBRWxCLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsU0FBUyxFQUFFLFFBQVEsRUFBRSxFQUFFO2dCQUMzQyxNQUFNLFNBQVMsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDO2dCQUNqQyxNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLElBQUksQ0FBQztnQkFDN0MsTUFBTSxZQUFZLEdBQUcsU0FBUyxDQUFDLFlBQVksSUFBSSxJQUFJLENBQUM7Z0JBQ3BELE1BQU0sT0FBTyxHQUFHLFNBQVMsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDO2dCQUUxQyxJQUFJLENBQUMsS0FBSyxFQUFFO29CQUNSLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQXFCLENBQUMsQ0FBQztvQkFDckMsT0FBTztpQkFDVjtnQkFFRCxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztvQkFDVixLQUFLO29CQUNMLFlBQVk7b0JBQ1osT0FBTztpQkFDUyxDQUFDLENBQUM7Z0JBRXRCLElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxDQUFDLElBQUksUUFBUSxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtvQkFDOUQsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFFZixHQUFHLEdBQUc7d0JBQ0YsSUFBSSxFQUFFLEVBQUU7cUJBQ0ssQ0FBQztpQkFDckI7WUFDTCxDQUFDLENBQUMsQ0FBQztZQUVILElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRTtnQkFDbEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQzthQUNyQjtZQUdELElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDbkIsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRTNCLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO0lBQzFCLENBQUM7SUFFRCxJQUFJLFNBQVM7UUFDVCxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUM1QyxJQUFJLElBQUksS0FBSyxDQUFDLEVBQUU7WUFDWixPQUFPLENBQUMsQ0FBQztTQUNaO1FBQ0QsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQztJQUNsQyxDQUFDO3FGQTFHUSxvQkFBb0I7b0VBQXBCLG9CQUFvQjs7WUNWakMsNEJBQTJDO1lBQ3ZDLHFFQXFFTTtZQUNWLGlCQUFPOztZQXZFRCwrREFBb0M7WUFDSSxlQUFjO1lBQWQsdUNBQWM7OztTRFMvQyxvQkFBb0I7dUZBQXBCLG9CQUFvQjtjQUpoQyxTQUFTOzJCQUNJLG1CQUFtQjtxRUFLcEIsVUFBVTtrQkFBbEIsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogU3VpdGVDUk0gaXMgYSBjdXN0b21lciByZWxhdGlvbnNoaXAgbWFuYWdlbWVudCBwcm9ncmFtIGRldmVsb3BlZCBieSBTYWxlc0FnaWxpdHkgTHRkLlxuICogQ29weXJpZ2h0IChDKSAyMDIxIFNhbGVzQWdpbGl0eSBMdGQuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGZyZWUgc29mdHdhcmU7IHlvdSBjYW4gcmVkaXN0cmlidXRlIGl0IGFuZC9vciBtb2RpZnkgaXQgdW5kZXJcbiAqIHRoZSB0ZXJtcyBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIHZlcnNpb24gMyBhcyBwdWJsaXNoZWQgYnkgdGhlXG4gKiBGcmVlIFNvZnR3YXJlIEZvdW5kYXRpb24gd2l0aCB0aGUgYWRkaXRpb24gb2YgdGhlIGZvbGxvd2luZyBwZXJtaXNzaW9uIGFkZGVkXG4gKiB0byBTZWN0aW9uIDE1IGFzIHBlcm1pdHRlZCBpbiBTZWN0aW9uIDcoYSk6IEZPUiBBTlkgUEFSVCBPRiBUSEUgQ09WRVJFRCBXT1JLXG4gKiBJTiBXSElDSCBUSEUgQ09QWVJJR0hUIElTIE9XTkVEIEJZIFNBTEVTQUdJTElUWSwgU0FMRVNBR0lMSVRZIERJU0NMQUlNUyBUSEVcbiAqIFdBUlJBTlRZIE9GIE5PTiBJTkZSSU5HRU1FTlQgT0YgVEhJUkQgUEFSVFkgUklHSFRTLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBkaXN0cmlidXRlZCBpbiB0aGUgaG9wZSB0aGF0IGl0IHdpbGwgYmUgdXNlZnVsLCBidXQgV0lUSE9VVFxuICogQU5ZIFdBUlJBTlRZOyB3aXRob3V0IGV2ZW4gdGhlIGltcGxpZWQgd2FycmFudHkgb2YgTUVSQ0hBTlRBQklMSVRZIG9yIEZJVE5FU1NcbiAqIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRS4gU2VlIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgZm9yIG1vcmVcbiAqIGRldGFpbHMuXG4gKlxuICogWW91IHNob3VsZCBoYXZlIHJlY2VpdmVkIGEgY29weSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiBhbG9uZyB3aXRoIHRoaXMgcHJvZ3JhbS4gIElmIG5vdCwgc2VlIDxodHRwOi8vd3d3LmdudS5vcmcvbGljZW5zZXMvPi5cbiAqXG4gKiBJbiBhY2NvcmRhbmNlIHdpdGggU2VjdGlvbiA3KGIpIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIHZlcnNpb24gMywgdGhlc2UgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IHJldGFpbiB0aGUgZGlzcGxheSBvZiB0aGVcbiAqIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIgbG9nby4gSWYgdGhlIGRpc3BsYXkgb2YgdGhlIGxvZ29zIGlzIG5vdCByZWFzb25hYmx5XG4gKiBmZWFzaWJsZSBmb3IgdGVjaG5pY2FsIHJlYXNvbnMsIHRoZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgZGlzcGxheVxuICogdGhlIHdvcmRzIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIuXG4gKi9cblxuaW1wb3J0IHtDb21wb25lbnQsIElucHV0fSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7RmllbGRNYXAsIFBhbmVsLCBSZWNvcmR9IGZyb20gJ2NvbW1vbic7XG5pbXBvcnQge0JyZWFrcG9pbnRPYnNlcnZlcn0gZnJvbSAnQGFuZ3VsYXIvY2RrL2xheW91dCc7XG5pbXBvcnQge0ZpZWxkR3JpZENvbHVtbiwgRmllbGRHcmlkUm93fSBmcm9tICcuLi9maWVsZC1ncmlkL2ZpZWxkLWdyaWQubW9kZWwnO1xuaW1wb3J0IHtCYXNlRmllbGRHcmlkQ29tcG9uZW50fSBmcm9tICcuLi9maWVsZC1ncmlkL2Jhc2UtZmllbGQtZ3JpZC5jb21wb25lbnQnO1xuaW1wb3J0IHtGaWVsZExheW91dENvbmZpZywgRmllbGRMYXlvdXREYXRhU291cmNlfSBmcm9tICcuL2ZpZWxkLWxheW91dC5tb2RlbCc7XG5cbkBDb21wb25lbnQoe1xuICAgIHNlbGVjdG9yOiAnc2NybS1maWVsZC1sYXlvdXQnLFxuICAgIHRlbXBsYXRlVXJsOiAnLi9maWVsZC1sYXlvdXQuY29tcG9uZW50Lmh0bWwnXG59KVxuZXhwb3J0IGNsYXNzIEZpZWxkTGF5b3V0Q29tcG9uZW50IGV4dGVuZHMgQmFzZUZpZWxkR3JpZENvbXBvbmVudCB7XG5cbiAgICBASW5wdXQoKSBkYXRhU291cmNlOiBGaWVsZExheW91dERhdGFTb3VyY2U7XG4gICAgY29uZmlnOiBGaWVsZExheW91dENvbmZpZztcbiAgICBsYXlvdXQ6IFBhbmVsO1xuICAgIGZpZWxkczogRmllbGRNYXA7XG4gICAgcmVjb3JkOiBSZWNvcmQ7XG5cbiAgICBiYXNlQ29sQ2xhc3MgPSB7XG4gICAgICAgIGNvbDogdHJ1ZSxcbiAgICAgICAgJ2Zvcm0tZ3JvdXAnOiB0cnVlLFxuICAgICAgICAnbS0xJzogZmFsc2UsXG4gICAgICAgICdtLTAnOiB0cnVlLFxuICAgICAgICAncGwtMyc6IHRydWUsXG4gICAgICAgICdwYi0yJzogdHJ1ZSxcbiAgICAgICAgJ3ByLTMnOiB0cnVlLFxuICAgICAgICAnZC1mbGV4JzogdHJ1ZSxcbiAgICAgICAgJ2ZsZXgtY29sdW1uJzogdHJ1ZSxcbiAgICAgICAgJ2p1c3RpZnktY29udGVudC1iZXR3ZWVuJzogdHJ1ZVxuICAgIH0gYXMgeyBba2V5OnN0cmluZ106IGJvb2xlYW4gfTtcblxuICAgIGJhc2VSb3dDbGFzcyA9IHtcbiAgICAgICAgJ2Zvcm0tcm93JzogdHJ1ZSxcbiAgICAgICAgJ2FsaWduLWl0ZW1zLXN0cmV0Y2gnOiB0cnVlXG4gICAgfSBhcyB7IFtrZXk6c3RyaW5nXTogYm9vbGVhbiB9O1xuXG4gICAgY29uc3RydWN0b3IocHJvdGVjdGVkIGJyZWFrcG9pbnRPYnNlcnZlcjogQnJlYWtwb2ludE9ic2VydmVyKSB7XG4gICAgICAgIHN1cGVyKGJyZWFrcG9pbnRPYnNlcnZlcik7XG4gICAgfVxuXG4gICAgbmdPbkluaXQoKTogdm9pZCB7XG5cbiAgICAgICAgdGhpcy5zdWJzY3JpcHRpb25zLnB1c2godGhpcy5kYXRhU291cmNlLmdldENvbmZpZygpLnN1YnNjcmliZShjb25maWcgPT4ge1xuICAgICAgICAgICAgdGhpcy5jb25maWcgPSB7Li4uY29uZmlnfTtcbiAgICAgICAgfSkpO1xuICAgICAgICB0aGlzLnN1YnNjcmlwdGlvbnMucHVzaCh0aGlzLmRhdGFTb3VyY2UuZ2V0TGF5b3V0KCkuc3Vic2NyaWJlKGxheW91dCA9PiB7XG4gICAgICAgICAgICB0aGlzLmxheW91dCA9IHsuLi5sYXlvdXR9O1xuICAgICAgICB9KSk7XG4gICAgICAgIHRoaXMuc3Vic2NyaXB0aW9ucy5wdXNoKHRoaXMuZGF0YVNvdXJjZS5nZXRGaWVsZHMoKS5zdWJzY3JpYmUoZmllbGRzID0+IHtcbiAgICAgICAgICAgIHRoaXMuZmllbGRzID0gey4uLmZpZWxkc307XG4gICAgICAgIH0pKTtcbiAgICAgICAgdGhpcy5zdWJzY3JpcHRpb25zLnB1c2godGhpcy5kYXRhU291cmNlLmdldFJlY29yZCgpLnN1YnNjcmliZShyZWNvcmQgPT4ge1xuICAgICAgICAgICAgdGhpcy5yZWNvcmQgPSB7Li4ucmVjb3JkfTtcbiAgICAgICAgfSkpO1xuXG4gICAgICAgIHN1cGVyLm5nT25Jbml0KCk7XG4gICAgfVxuXG4gICAgYnVpbGRHcmlkKCk6IHZvaWQge1xuICAgICAgICBjb25zdCBncmlkOiBGaWVsZEdyaWRSb3dbXSA9IFtdO1xuXG4gICAgICAgIGlmICghdGhpcy5maWVsZHMgfHwgT2JqZWN0LmtleXModGhpcy5maWVsZHMpLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgdGhpcy5maWVsZEdyaWQgPSBbXTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMubGF5b3V0LnJvd3MuZm9yRWFjaChsYXlvdXRSb3cgPT4ge1xuICAgICAgICAgICAgbGV0IHJvdyA9IHtcbiAgICAgICAgICAgICAgICBjb2xzOiBbXVxuICAgICAgICAgICAgfSBhcyBGaWVsZEdyaWRSb3c7XG5cbiAgICAgICAgICAgIGxheW91dFJvdy5jb2xzLmZvckVhY2goKGxheW91dENvbCwgY29sSW5kZXgpID0+IHtcbiAgICAgICAgICAgICAgICBjb25zdCBmaWVsZE5hbWUgPSBsYXlvdXRDb2wubmFtZTtcbiAgICAgICAgICAgICAgICBjb25zdCBmaWVsZCA9IHRoaXMuZmllbGRzW2ZpZWxkTmFtZV0gfHwgbnVsbDtcbiAgICAgICAgICAgICAgICBjb25zdCBmaWVsZEFjdGlvbnMgPSBsYXlvdXRDb2wuZmllbGRBY3Rpb25zIHx8IG51bGw7XG4gICAgICAgICAgICAgICAgY29uc3QgYWRhcHRvciA9IGxheW91dENvbC5hZGFwdG9yID8/IG51bGw7XG5cbiAgICAgICAgICAgICAgICBpZiAoIWZpZWxkKSB7XG4gICAgICAgICAgICAgICAgICAgIHJvdy5jb2xzLnB1c2goe30gYXMgRmllbGRHcmlkQ29sdW1uKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHJvdy5jb2xzLnB1c2goe1xuICAgICAgICAgICAgICAgICAgICBmaWVsZCxcbiAgICAgICAgICAgICAgICAgICAgZmllbGRBY3Rpb25zLFxuICAgICAgICAgICAgICAgICAgICBhZGFwdG9yXG4gICAgICAgICAgICAgICAgfSBhcyBGaWVsZEdyaWRDb2x1bW4pO1xuXG4gICAgICAgICAgICAgICAgaWYgKHRoaXMuY29sTnVtYmVyID09PSAxICYmIGNvbEluZGV4IDwgbGF5b3V0Um93LmNvbHMubGVuZ3RoIC0gMSkge1xuICAgICAgICAgICAgICAgICAgICBncmlkLnB1c2gocm93KTtcblxuICAgICAgICAgICAgICAgICAgICByb3cgPSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb2xzOiBbXVxuICAgICAgICAgICAgICAgICAgICB9IGFzIEZpZWxkR3JpZFJvdztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcblxuICAgICAgICAgICAgaWYgKHJvdy5jb2xzLmxlbmd0aCA8IHRoaXMuY29sTnVtYmVyKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5maWxsUm93KHJvdyk7XG4gICAgICAgICAgICB9XG5cblxuICAgICAgICAgICAgZ3JpZC5wdXNoKHJvdyk7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMuYWRkU3BlY2lhbFNsb3RzKGdyaWQpO1xuXG4gICAgICAgIHRoaXMuZmllbGRHcmlkID0gZ3JpZDtcbiAgICB9XG5cbiAgICBnZXQgY29sTnVtYmVyKCk6IG51bWJlciB7XG4gICAgICAgIGNvbnN0IHNpemUgPSB0aGlzLnNpemVNYXBbdGhpcy5jdXJyZW50U2l6ZV07XG4gICAgICAgIGlmIChzaXplID09PSAxKSB7XG4gICAgICAgICAgICByZXR1cm4gMTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gdGhpcy5jb25maWcubWF4Q29sdW1ucztcbiAgICB9XG59XG4iLCI8ISAtLVxuLyoqXG4qIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiogQ29weXJpZ2h0IChDKSAyMDIxIFNhbGVzQWdpbGl0eSBMdGQuXG4qXG4qIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4qIHRoZSB0ZXJtcyBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIHZlcnNpb24gMyBhcyBwdWJsaXNoZWQgYnkgdGhlXG4qIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuKiBJTiBXSElDSCBUSEUgQ09QWVJJR0hUIElTIE9XTkVEIEJZIFNBTEVTQUdJTElUWSwgU0FMRVNBR0lMSVRZIERJU0NMQUlNUyBUSEVcbiogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4qXG4qIFRoaXMgcHJvZ3JhbSBpcyBkaXN0cmlidXRlZCBpbiB0aGUgaG9wZSB0aGF0IGl0IHdpbGwgYmUgdXNlZnVsLCBidXQgV0lUSE9VVFxuKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4qIGRldGFpbHMuXG4qXG4qIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuKiBhbG9uZyB3aXRoIHRoaXMgcHJvZ3JhbS4gIElmIG5vdCwgc2VlIGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy5cbipcbiogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4qIHZlcnNpb24gMywgdGhlc2UgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IHJldGFpbiB0aGUgZGlzcGxheSBvZiB0aGVcbiogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiogdGhlIHdvcmRzIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIuXG4qL1xuLS0+XG48Zm9ybSBjbGFzcz1cImZpZWxkLWxheW91dCB7e2NvbmZpZy5tb2RlfX1cIj5cbiAgICA8ZGl2IFtuZ0NsYXNzXT1cInJvd0NsYXNzXCIgKm5nRm9yPVwibGV0IHJvdyBvZiBmaWVsZEdyaWQ7IGluZGV4IGFzIGlcIj5cblxuICAgICAgICA8ZGl2ICpuZ0Zvcj1cImxldCBjb2wgb2Ygcm93LmNvbHM7IGluZGV4IGFzIGNvbE51bWJlclwiXG4gICAgICAgICAgICAgW2NsYXNzLmZpZWxkLWNvbHVtbi1ib3JkZXJlZF09XCJyb3cuY29scy5sZW5ndGggPiAxICYmIGNvbE51bWJlciA8IHJvdy5jb2xzLmxlbmd0aCAtIDFcIlxuICAgICAgICAgICAgIFtuZ0NsYXNzXT1cImNvbENsYXNzXCI+XG5cbiAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJjb2wuZmllbGQgJiYgY29sLmZpZWxkLmRpc3BsYXkgIT09ICdub25lJ1wiPlxuICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJsYWJlbC1jb250YWluZXJcIj5cbiAgICAgICAgICAgICAgICAgICAgPHN0cm9uZz5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxsYWJlbCBbbmdDbGFzc109XCJsYWJlbENsYXNzXCI+e3tjb2wuZmllbGQubGFiZWwgfCB1cHBlcmNhc2V9fTwvbGFiZWw+OlxuICAgICAgICAgICAgICAgICAgICAgICAgPG5nLWNvbnRhaW5lclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICpuZ0lmPVwiY29sLmZpZWxkLmRlZmluaXRpb24ucmVxdWlyZWQgJiYgKFsnZWRpdCcsICdjcmVhdGUnXS5pbmNsdWRlcyhjb25maWcubW9kZSkpXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPHNwYW4gY2xhc3M9XCJyZXF1aXJlZFwiPio8L3NwYW4+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cbiAgICAgICAgICAgICAgICAgICAgPC9zdHJvbmc+XG4gICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cImQtZmxleCBmbGV4LWdyb3ctMVwiXG4gICAgICAgICAgICAgICAgICAgIFtuZ0NsYXNzXT1cInsgJ2FsaWduLWl0ZW1zLWNlbnRlcic6IChjb2w/LmZpZWxkQWN0aW9ucyAmJiBjb2w/LmZpZWxkQWN0aW9ucz8ucG9zaXRpb24gPT09ICdpbmxpbmUnKSB9XCI+XG4gICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJmbGV4LWdyb3ctMSB0ZXh0LWJyZWFrXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1maWVsZCBbdHlwZV09XCJjb2wuZmllbGQudHlwZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbbW9kZV09XCJjb25maWcubW9kZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBba2xhc3NdPVwiaW5wdXRDbGFzc1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbZmllbGRdPVwiY29sLmZpZWxkXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtyZWNvcmRdPVwicmVjb3JkXCI+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L3Njcm0tZmllbGQ+XG4gICAgICAgICAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICAgICAgICAgIDxuZy1jb250YWluZXIgKm5nSWY9XCJjb2w/LmZpZWxkQWN0aW9ucyAmJiAoKGNvbD8uZmllbGRBY3Rpb25zPy5wb3NpdGlvbiA/PyAnaW5saW5lJykgPT09ICdpbmxpbmUnKVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGRpdj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1hY3Rpb24tZ3JvdXAtbWVudVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBbY29uZmlnXT1cImNvbC5hZGFwdG9yXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2J1dHRvbkdyb3VwQ2xhc3NdID0gXCJjb2wuZmllbGRBY3Rpb25zPy5jb250YWluZXJLbGFzcyA/PyAnJ1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFtrbGFzc10gPSBcImNvbC5maWVsZEFjdGlvbnM/LmtsYXNzID8/ICcnXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9zY3JtLWFjdGlvbi1ncm91cC1tZW51PlxuICAgICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIDwvbmctY29udGFpbmVyPlxuXG4gICAgICAgICAgICAgICAgICAgIDxkaXY+XG4gICAgICAgICAgICAgICAgICAgICAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cInJlY29yZC1hY3Rpb24tYnV0dG9uXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKGNsaWNrKT1cInRoaXMuZGF0YVNvdXJjZS5nZXRFZGl0QWN0aW9uKClcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAqbmdJZj1cImNvbC5maWVsZC5kZWZpbml0aW9uLmlubGluZV9lZGl0ICE9PSBmYWxzZSAmJiAhY29sLmZpZWxkLnJlYWRvbmx5ICYmICFjb2wuZmllbGQuZGVmaW5pdGlvbi5yZWFkb25seSAmJiB0aGlzLmRhdGFTb3VyY2UuaW5saW5lRWRpdCAmJiBjb25maWcubW9kZSA9PT0gJ2RldGFpbCdcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8c2NybS1pbWFnZSBjbGFzcz1cInNpY29uXCIgaW1hZ2U9XCJwZW5jaWxcIj48L3Njcm0taW1hZ2U+XG4gICAgICAgICAgICAgICAgICAgICAgICA8L2J1dHRvbj5cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cImNvbD8uZmllbGRBY3Rpb25zICYmICgoY29sPy5maWVsZEFjdGlvbnM/LnBvc2l0aW9uID8/ICdpbmxpbmUnICkgPT09ICd2ZXJ0aWNhbCcpXCI+XG4gICAgICAgICAgICAgICAgPHNjcm0tYWN0aW9uLWdyb3VwLW1lbnVcbiAgICAgICAgICAgICAgICAgICAgW2NvbmZpZ109XCJjb2wuYWRhcHRvclwiXG4gICAgICAgICAgICAgICAgICAgIFtidXR0b25Hcm91cENsYXNzXT1cImNvbC5maWVsZEFjdGlvbnM/LmNvbnRhaW5lcktsYXNzID8/ICcnXCJcbiAgICAgICAgICAgICAgICAgICAgW2tsYXNzXSA9IFwiY29sLmZpZWxkQWN0aW9ucz8ua2xhc3MgPz8gJydcIlxuICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICA8L3Njcm0tYWN0aW9uLWdyb3VwLW1lbnU+XG4gICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cImNvbC5hY3Rpb25TbG90XCI+XG4gICAgICAgICAgICAgICAgPG5nLWNvbnRlbnQgc2VsZWN0PVwiW2ZpZWxkLWdyaWQtYWN0aW9uc11cIj48L25nLWNvbnRlbnQ+XG4gICAgICAgICAgICA8L25nLWNvbnRhaW5lcj5cblxuICAgICAgICAgICAgPG5nLWNvbnRhaW5lciAqbmdJZj1cImNvbC5zcGVjaWFsU2xvdFwiPlxuICAgICAgICAgICAgICAgIDxuZy1jb250ZW50IHNlbGVjdD1cIltmaWVsZC1ncmlkLXNwZWNpYWxdXCI+PC9uZy1jb250ZW50PlxuICAgICAgICAgICAgPC9uZy1jb250YWluZXI+XG5cbiAgICAgICAgICAgIDxkaXYgKm5nSWY9XCJjb2wuZmllbGQgJiYgY29sLmZpZWxkPy5kaXNwbGF5ICE9PSAnbm9uZScgJiYgaSA8IGZpZWxkR3JpZC5sZW5ndGggLSAxXCJcbiAgICAgICAgICAgICAgICAgY2xhc3M9XCJmaWVsZC1zZXBhcmF0aW9uIG10LTJcIj5cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L2Rpdj5cbiAgICA8L2Rpdj5cbjwvZm9ybT5cbiJdfQ==