/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NavbarUiComponent } from './navbar.component';
import { LogoUiModule } from '../logo/logo.module';
import { LogoutUiModule } from '../logout/logout.module';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { RouterModule } from '@angular/router';
import { MenuItemLinkComponent } from './menu-item-link/menu-item-link.component';
import { GroupedMenuItemComponent } from './grouped-menu-item/grouped-menu-item.component';
import { MenuItemsListComponent } from './menu-items-list/menu-items-list.component';
import { MenuRecentlyViewedComponent } from './menu-recently-viewed/menu-recently-viewed.component';
import { HomeMenuItemComponent } from './home-menu-item/home-menu-item.component';
import { MenuItemComponent } from './menu-item/menu-item.component';
import { ImageModule } from '../image/image.module';
import { BaseNavbarComponent } from './base-navbar/base-navbar.component';
import { DynamicModule } from 'ng-dynamic-component';
import { BaseMenuItemLinkComponent } from './menu-item-link/base-menu-item-link.component';
import { BaseMenuItemComponent } from './menu-item/base-menu-item.component';
import { BaseGroupedMenuItemComponent } from './grouped-menu-item/base-grouped-menu-item.component';
import { BaseHomeMenuItemComponent } from './home-menu-item/base-home-menu-item.component';
import { BaseMenuRecentlyViewedComponent } from './menu-recently-viewed/base-menu-recently-viewed.component';
import { BaseMenuItemsListComponent } from './menu-items-list/base-menu-items-list.component';
import { LogoutUiComponent } from '../logout/logout.component';
import { LabelModule } from '../label/label.module';
import { SubMenuRecentlyViewedComponent } from './sub-menu-recently-viewed/sub-menu-recently-viewed.component';
import { BaseSubMenuRecentlyViewedComponent } from './sub-menu-recently-viewed/base-sub-menu-recently-viewed.component';
import { BaseSubMenuFavoritesComponent } from './sub-menu-favorites/base-sub-menu-favorites.component';
import { SubMenuFavoritesComponent } from './sub-menu-favorites/sub-menu-favorites.component';
import { MenuFavoritesComponent } from './menu-favorites/menu-favorites.component';
import { BaseMenuFavoritesComponent } from './menu-favorites/base-menu-favorites.component';
import { BaseFavoritesComponent } from './menu-favorites/base-favorites.component';
import { FormsModule } from '@angular/forms';
import { NotificationsModule } from '../../containers/notifications/notifications.module';
import { SearchBarModule } from '../search-bar/search-bar.module';
import { DropdownButtonModule } from "../dropdown-button/dropdown-button.module";
import { RecentlyViewedComponent } from "./recently-viewed/recently-viewed.component";
import { TruncatePipe } from "../../pipes/truncate/truncate.pipe";
import * as i0 from "@angular/core";
class NavbarUiModule {
    static { this.ɵfac = function NavbarUiModule_Factory(t) { return new (t || NavbarUiModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: NavbarUiModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            LogoUiModule,
            LogoutUiModule,
            NgbModule,
            RouterModule,
            ImageModule,
            DynamicModule,
            LabelModule,
            FormsModule,
            NotificationsModule,
            SearchBarModule,
            RecentlyViewedComponent,
            DropdownButtonModule] }); }
}
export { NavbarUiModule };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(NavbarUiModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    NavbarUiComponent,
                    MenuItemComponent,
                    BaseMenuItemComponent,
                    MenuRecentlyViewedComponent,
                    BaseMenuRecentlyViewedComponent,
                    SubMenuRecentlyViewedComponent,
                    BaseSubMenuRecentlyViewedComponent,
                    BaseFavoritesComponent,
                    MenuFavoritesComponent,
                    BaseMenuFavoritesComponent,
                    SubMenuFavoritesComponent,
                    BaseSubMenuFavoritesComponent,
                    HomeMenuItemComponent,
                    MenuItemLinkComponent,
                    BaseHomeMenuItemComponent,
                    BaseMenuItemLinkComponent,
                    GroupedMenuItemComponent,
                    BaseGroupedMenuItemComponent,
                    MenuItemsListComponent,
                    BaseMenuItemsListComponent,
                    BaseNavbarComponent
                ],
                exports: [
                    NavbarUiComponent,
                    MenuItemComponent,
                    BaseMenuItemComponent,
                    MenuRecentlyViewedComponent,
                    BaseMenuRecentlyViewedComponent,
                    SubMenuRecentlyViewedComponent,
                    BaseSubMenuRecentlyViewedComponent,
                    BaseFavoritesComponent,
                    MenuFavoritesComponent,
                    SubMenuFavoritesComponent,
                    BaseSubMenuFavoritesComponent,
                    HomeMenuItemComponent,
                    MenuItemLinkComponent,
                    BaseHomeMenuItemComponent,
                    BaseMenuItemLinkComponent,
                    GroupedMenuItemComponent,
                    BaseGroupedMenuItemComponent,
                    MenuItemsListComponent,
                    BaseMenuItemsListComponent,
                    BaseNavbarComponent,
                    LogoutUiComponent
                ],
                imports: [
                    CommonModule,
                    LogoUiModule,
                    LogoutUiModule,
                    NgbModule,
                    RouterModule,
                    ImageModule,
                    DynamicModule,
                    LabelModule,
                    FormsModule,
                    NotificationsModule,
                    SearchBarModule,
                    TruncatePipe,
                    RecentlyViewedComponent,
                    DropdownButtonModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(NavbarUiModule, { declarations: [NavbarUiComponent,
        MenuItemComponent,
        BaseMenuItemComponent,
        MenuRecentlyViewedComponent,
        BaseMenuRecentlyViewedComponent,
        SubMenuRecentlyViewedComponent,
        BaseSubMenuRecentlyViewedComponent,
        BaseFavoritesComponent,
        MenuFavoritesComponent,
        BaseMenuFavoritesComponent,
        SubMenuFavoritesComponent,
        BaseSubMenuFavoritesComponent,
        HomeMenuItemComponent,
        MenuItemLinkComponent,
        BaseHomeMenuItemComponent,
        BaseMenuItemLinkComponent,
        GroupedMenuItemComponent,
        BaseGroupedMenuItemComponent,
        MenuItemsListComponent,
        BaseMenuItemsListComponent,
        BaseNavbarComponent], imports: [CommonModule,
        LogoUiModule,
        LogoutUiModule,
        NgbModule,
        RouterModule,
        ImageModule,
        DynamicModule,
        LabelModule,
        FormsModule,
        NotificationsModule,
        SearchBarModule,
        TruncatePipe,
        RecentlyViewedComponent,
        DropdownButtonModule], exports: [NavbarUiComponent,
        MenuItemComponent,
        BaseMenuItemComponent,
        MenuRecentlyViewedComponent,
        BaseMenuRecentlyViewedComponent,
        SubMenuRecentlyViewedComponent,
        BaseSubMenuRecentlyViewedComponent,
        BaseFavoritesComponent,
        MenuFavoritesComponent,
        SubMenuFavoritesComponent,
        BaseSubMenuFavoritesComponent,
        HomeMenuItemComponent,
        MenuItemLinkComponent,
        BaseHomeMenuItemComponent,
        BaseMenuItemLinkComponent,
        GroupedMenuItemComponent,
        BaseGroupedMenuItemComponent,
        MenuItemsListComponent,
        BaseMenuItemsListComponent,
        BaseNavbarComponent,
        LogoutUiComponent] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmF2YmFyLm1vZHVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi9jb21wb25lbnRzL25hdmJhci9uYXZiYXIubW9kdWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F3Qkc7QUFFSCxPQUFPLEVBQUMsUUFBUSxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBQ3ZDLE9BQU8sRUFBQyxZQUFZLEVBQUMsTUFBTSxpQkFBaUIsQ0FBQztBQUM3QyxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxvQkFBb0IsQ0FBQztBQUVyRCxPQUFPLEVBQUMsWUFBWSxFQUFDLE1BQU0scUJBQXFCLENBQUM7QUFDakQsT0FBTyxFQUFDLGNBQWMsRUFBQyxNQUFNLHlCQUF5QixDQUFDO0FBQ3ZELE9BQU8sRUFBQyxTQUFTLEVBQUMsTUFBTSw0QkFBNEIsQ0FBQztBQUNyRCxPQUFPLEVBQUMsWUFBWSxFQUFDLE1BQU0saUJBQWlCLENBQUM7QUFDN0MsT0FBTyxFQUFDLHFCQUFxQixFQUFDLE1BQU0sMkNBQTJDLENBQUM7QUFDaEYsT0FBTyxFQUFDLHdCQUF3QixFQUFDLE1BQU0saURBQWlELENBQUM7QUFDekYsT0FBTyxFQUFDLHNCQUFzQixFQUFDLE1BQU0sNkNBQTZDLENBQUM7QUFDbkYsT0FBTyxFQUFDLDJCQUEyQixFQUFDLE1BQU0sdURBQXVELENBQUM7QUFDbEcsT0FBTyxFQUFDLHFCQUFxQixFQUFDLE1BQU0sMkNBQTJDLENBQUM7QUFDaEYsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0saUNBQWlDLENBQUM7QUFDbEUsT0FBTyxFQUFDLFdBQVcsRUFBQyxNQUFNLHVCQUF1QixDQUFDO0FBQ2xELE9BQU8sRUFBQyxtQkFBbUIsRUFBQyxNQUFNLHFDQUFxQyxDQUFDO0FBQ3hFLE9BQU8sRUFBQyxhQUFhLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUNuRCxPQUFPLEVBQUMseUJBQXlCLEVBQUMsTUFBTSxnREFBZ0QsQ0FBQztBQUN6RixPQUFPLEVBQUMscUJBQXFCLEVBQUMsTUFBTSxzQ0FBc0MsQ0FBQztBQUMzRSxPQUFPLEVBQUMsNEJBQTRCLEVBQUMsTUFBTSxzREFBc0QsQ0FBQztBQUNsRyxPQUFPLEVBQUMseUJBQXlCLEVBQUMsTUFBTSxnREFBZ0QsQ0FBQztBQUN6RixPQUFPLEVBQUMsK0JBQStCLEVBQUMsTUFBTSw0REFBNEQsQ0FBQztBQUMzRyxPQUFPLEVBQUMsMEJBQTBCLEVBQUMsTUFBTSxrREFBa0QsQ0FBQztBQUM1RixPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSw0QkFBNEIsQ0FBQztBQUM3RCxPQUFPLEVBQUMsV0FBVyxFQUFDLE1BQU0sdUJBQXVCLENBQUM7QUFDbEQsT0FBTyxFQUFDLDhCQUE4QixFQUFDLE1BQU0sK0RBQStELENBQUM7QUFDN0csT0FBTyxFQUFDLGtDQUFrQyxFQUFDLE1BQU0sb0VBQW9FLENBQUM7QUFDdEgsT0FBTyxFQUFDLDZCQUE2QixFQUFDLE1BQU0sd0RBQXdELENBQUM7QUFDckcsT0FBTyxFQUFDLHlCQUF5QixFQUFDLE1BQU0sbURBQW1ELENBQUM7QUFDNUYsT0FBTyxFQUFDLHNCQUFzQixFQUFDLE1BQU0sMkNBQTJDLENBQUM7QUFDakYsT0FBTyxFQUFDLDBCQUEwQixFQUFDLE1BQU0sZ0RBQWdELENBQUM7QUFDMUYsT0FBTyxFQUFDLHNCQUFzQixFQUFDLE1BQU0sMkNBQTJDLENBQUM7QUFDakYsT0FBTyxFQUFDLFdBQVcsRUFBQyxNQUFNLGdCQUFnQixDQUFDO0FBQzNDLE9BQU8sRUFBQyxtQkFBbUIsRUFBQyxNQUFNLHFEQUFxRCxDQUFDO0FBQ3hGLE9BQU8sRUFBQyxlQUFlLEVBQUMsTUFBTSxpQ0FBaUMsQ0FBQztBQUNoRSxPQUFPLEVBQUMsb0JBQW9CLEVBQUMsTUFBTSwyQ0FBMkMsQ0FBQztBQUMvRSxPQUFPLEVBQUMsdUJBQXVCLEVBQUMsTUFBTSw2Q0FBNkMsQ0FBQztBQUNwRixPQUFPLEVBQUMsWUFBWSxFQUFDLE1BQU0sb0NBQW9DLENBQUM7O0FBR2hFLE1BZ0VhLGNBQWM7K0VBQWQsY0FBYzttRUFBZCxjQUFjO3VFQWhCbkIsWUFBWTtZQUNaLFlBQVk7WUFDWixjQUFjO1lBQ2QsU0FBUztZQUNULFlBQVk7WUFDWixXQUFXO1lBQ1gsYUFBYTtZQUNiLFdBQVc7WUFDWCxXQUFXO1lBQ1gsbUJBQW1CO1lBQ25CLGVBQWU7WUFFZix1QkFBdUI7WUFDdkIsb0JBQW9COztTQUdmLGNBQWM7dUZBQWQsY0FBYztjQWhFMUIsUUFBUTtlQUFDO2dCQUNOLFlBQVksRUFBRTtvQkFDVixpQkFBaUI7b0JBQ2pCLGlCQUFpQjtvQkFDakIscUJBQXFCO29CQUNyQiwyQkFBMkI7b0JBQzNCLCtCQUErQjtvQkFDL0IsOEJBQThCO29CQUM5QixrQ0FBa0M7b0JBQ2xDLHNCQUFzQjtvQkFDdEIsc0JBQXNCO29CQUN0QiwwQkFBMEI7b0JBQzFCLHlCQUF5QjtvQkFDekIsNkJBQTZCO29CQUM3QixxQkFBcUI7b0JBQ3JCLHFCQUFxQjtvQkFDckIseUJBQXlCO29CQUN6Qix5QkFBeUI7b0JBQ3pCLHdCQUF3QjtvQkFDeEIsNEJBQTRCO29CQUM1QixzQkFBc0I7b0JBQ3RCLDBCQUEwQjtvQkFDMUIsbUJBQW1CO2lCQUN0QjtnQkFDRCxPQUFPLEVBQUU7b0JBQ0wsaUJBQWlCO29CQUNqQixpQkFBaUI7b0JBQ2pCLHFCQUFxQjtvQkFDckIsMkJBQTJCO29CQUMzQiwrQkFBK0I7b0JBQy9CLDhCQUE4QjtvQkFDOUIsa0NBQWtDO29CQUNsQyxzQkFBc0I7b0JBQ3RCLHNCQUFzQjtvQkFDdEIseUJBQXlCO29CQUN6Qiw2QkFBNkI7b0JBQzdCLHFCQUFxQjtvQkFDckIscUJBQXFCO29CQUNyQix5QkFBeUI7b0JBQ3pCLHlCQUF5QjtvQkFDekIsd0JBQXdCO29CQUN4Qiw0QkFBNEI7b0JBQzVCLHNCQUFzQjtvQkFDdEIsMEJBQTBCO29CQUMxQixtQkFBbUI7b0JBQ25CLGlCQUFpQjtpQkFDcEI7Z0JBQ0QsT0FBTyxFQUFFO29CQUNMLFlBQVk7b0JBQ1osWUFBWTtvQkFDWixjQUFjO29CQUNkLFNBQVM7b0JBQ1QsWUFBWTtvQkFDWixXQUFXO29CQUNYLGFBQWE7b0JBQ2IsV0FBVztvQkFDWCxXQUFXO29CQUNYLG1CQUFtQjtvQkFDbkIsZUFBZTtvQkFDZixZQUFZO29CQUNaLHVCQUF1QjtvQkFDdkIsb0JBQW9CO2lCQUN2QjthQUNKOzt3RkFDWSxjQUFjLG1CQTlEbkIsaUJBQWlCO1FBQ2pCLGlCQUFpQjtRQUNqQixxQkFBcUI7UUFDckIsMkJBQTJCO1FBQzNCLCtCQUErQjtRQUMvQiw4QkFBOEI7UUFDOUIsa0NBQWtDO1FBQ2xDLHNCQUFzQjtRQUN0QixzQkFBc0I7UUFDdEIsMEJBQTBCO1FBQzFCLHlCQUF5QjtRQUN6Qiw2QkFBNkI7UUFDN0IscUJBQXFCO1FBQ3JCLHFCQUFxQjtRQUNyQix5QkFBeUI7UUFDekIseUJBQXlCO1FBQ3pCLHdCQUF3QjtRQUN4Qiw0QkFBNEI7UUFDNUIsc0JBQXNCO1FBQ3RCLDBCQUEwQjtRQUMxQixtQkFBbUIsYUEwQm5CLFlBQVk7UUFDWixZQUFZO1FBQ1osY0FBYztRQUNkLFNBQVM7UUFDVCxZQUFZO1FBQ1osV0FBVztRQUNYLGFBQWE7UUFDYixXQUFXO1FBQ1gsV0FBVztRQUNYLG1CQUFtQjtRQUNuQixlQUFlO1FBQ2YsWUFBWTtRQUNaLHVCQUF1QjtRQUN2QixvQkFBb0IsYUFwQ3BCLGlCQUFpQjtRQUNqQixpQkFBaUI7UUFDakIscUJBQXFCO1FBQ3JCLDJCQUEyQjtRQUMzQiwrQkFBK0I7UUFDL0IsOEJBQThCO1FBQzlCLGtDQUFrQztRQUNsQyxzQkFBc0I7UUFDdEIsc0JBQXNCO1FBQ3RCLHlCQUF5QjtRQUN6Qiw2QkFBNkI7UUFDN0IscUJBQXFCO1FBQ3JCLHFCQUFxQjtRQUNyQix5QkFBeUI7UUFDekIseUJBQXlCO1FBQ3pCLHdCQUF3QjtRQUN4Qiw0QkFBNEI7UUFDNUIsc0JBQXNCO1FBQ3RCLDBCQUEwQjtRQUMxQixtQkFBbUI7UUFDbkIsaUJBQWlCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4gKiBDb3B5cmlnaHQgKEMpIDIwMjEgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuICogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiAqIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiAqIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiAqIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuICogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4gKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuICogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuICogZGV0YWlscy5cbiAqXG4gKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgPGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy8+LlxuICpcbiAqIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuICogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiAqIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4gKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiAqL1xuXG5pbXBvcnQge05nTW9kdWxlfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7Q29tbW9uTW9kdWxlfSBmcm9tICdAYW5ndWxhci9jb21tb24nO1xuaW1wb3J0IHtOYXZiYXJVaUNvbXBvbmVudH0gZnJvbSAnLi9uYXZiYXIuY29tcG9uZW50JztcblxuaW1wb3J0IHtMb2dvVWlNb2R1bGV9IGZyb20gJy4uL2xvZ28vbG9nby5tb2R1bGUnO1xuaW1wb3J0IHtMb2dvdXRVaU1vZHVsZX0gZnJvbSAnLi4vbG9nb3V0L2xvZ291dC5tb2R1bGUnO1xuaW1wb3J0IHtOZ2JNb2R1bGV9IGZyb20gJ0BuZy1ib290c3RyYXAvbmctYm9vdHN0cmFwJztcbmltcG9ydCB7Um91dGVyTW9kdWxlfSBmcm9tICdAYW5ndWxhci9yb3V0ZXInO1xuaW1wb3J0IHtNZW51SXRlbUxpbmtDb21wb25lbnR9IGZyb20gJy4vbWVudS1pdGVtLWxpbmsvbWVudS1pdGVtLWxpbmsuY29tcG9uZW50JztcbmltcG9ydCB7R3JvdXBlZE1lbnVJdGVtQ29tcG9uZW50fSBmcm9tICcuL2dyb3VwZWQtbWVudS1pdGVtL2dyb3VwZWQtbWVudS1pdGVtLmNvbXBvbmVudCc7XG5pbXBvcnQge01lbnVJdGVtc0xpc3RDb21wb25lbnR9IGZyb20gJy4vbWVudS1pdGVtcy1saXN0L21lbnUtaXRlbXMtbGlzdC5jb21wb25lbnQnO1xuaW1wb3J0IHtNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnR9IGZyb20gJy4vbWVudS1yZWNlbnRseS12aWV3ZWQvbWVudS1yZWNlbnRseS12aWV3ZWQuY29tcG9uZW50JztcbmltcG9ydCB7SG9tZU1lbnVJdGVtQ29tcG9uZW50fSBmcm9tICcuL2hvbWUtbWVudS1pdGVtL2hvbWUtbWVudS1pdGVtLmNvbXBvbmVudCc7XG5pbXBvcnQge01lbnVJdGVtQ29tcG9uZW50fSBmcm9tICcuL21lbnUtaXRlbS9tZW51LWl0ZW0uY29tcG9uZW50JztcbmltcG9ydCB7SW1hZ2VNb2R1bGV9IGZyb20gJy4uL2ltYWdlL2ltYWdlLm1vZHVsZSc7XG5pbXBvcnQge0Jhc2VOYXZiYXJDb21wb25lbnR9IGZyb20gJy4vYmFzZS1uYXZiYXIvYmFzZS1uYXZiYXIuY29tcG9uZW50JztcbmltcG9ydCB7RHluYW1pY01vZHVsZX0gZnJvbSAnbmctZHluYW1pYy1jb21wb25lbnQnO1xuaW1wb3J0IHtCYXNlTWVudUl0ZW1MaW5rQ29tcG9uZW50fSBmcm9tICcuL21lbnUtaXRlbS1saW5rL2Jhc2UtbWVudS1pdGVtLWxpbmsuY29tcG9uZW50JztcbmltcG9ydCB7QmFzZU1lbnVJdGVtQ29tcG9uZW50fSBmcm9tICcuL21lbnUtaXRlbS9iYXNlLW1lbnUtaXRlbS5jb21wb25lbnQnO1xuaW1wb3J0IHtCYXNlR3JvdXBlZE1lbnVJdGVtQ29tcG9uZW50fSBmcm9tICcuL2dyb3VwZWQtbWVudS1pdGVtL2Jhc2UtZ3JvdXBlZC1tZW51LWl0ZW0uY29tcG9uZW50JztcbmltcG9ydCB7QmFzZUhvbWVNZW51SXRlbUNvbXBvbmVudH0gZnJvbSAnLi9ob21lLW1lbnUtaXRlbS9iYXNlLWhvbWUtbWVudS1pdGVtLmNvbXBvbmVudCc7XG5pbXBvcnQge0Jhc2VNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnR9IGZyb20gJy4vbWVudS1yZWNlbnRseS12aWV3ZWQvYmFzZS1tZW51LXJlY2VudGx5LXZpZXdlZC5jb21wb25lbnQnO1xuaW1wb3J0IHtCYXNlTWVudUl0ZW1zTGlzdENvbXBvbmVudH0gZnJvbSAnLi9tZW51LWl0ZW1zLWxpc3QvYmFzZS1tZW51LWl0ZW1zLWxpc3QuY29tcG9uZW50JztcbmltcG9ydCB7TG9nb3V0VWlDb21wb25lbnR9IGZyb20gJy4uL2xvZ291dC9sb2dvdXQuY29tcG9uZW50JztcbmltcG9ydCB7TGFiZWxNb2R1bGV9IGZyb20gJy4uL2xhYmVsL2xhYmVsLm1vZHVsZSc7XG5pbXBvcnQge1N1Yk1lbnVSZWNlbnRseVZpZXdlZENvbXBvbmVudH0gZnJvbSAnLi9zdWItbWVudS1yZWNlbnRseS12aWV3ZWQvc3ViLW1lbnUtcmVjZW50bHktdmlld2VkLmNvbXBvbmVudCc7XG5pbXBvcnQge0Jhc2VTdWJNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnR9IGZyb20gJy4vc3ViLW1lbnUtcmVjZW50bHktdmlld2VkL2Jhc2Utc3ViLW1lbnUtcmVjZW50bHktdmlld2VkLmNvbXBvbmVudCc7XG5pbXBvcnQge0Jhc2VTdWJNZW51RmF2b3JpdGVzQ29tcG9uZW50fSBmcm9tICcuL3N1Yi1tZW51LWZhdm9yaXRlcy9iYXNlLXN1Yi1tZW51LWZhdm9yaXRlcy5jb21wb25lbnQnO1xuaW1wb3J0IHtTdWJNZW51RmF2b3JpdGVzQ29tcG9uZW50fSBmcm9tICcuL3N1Yi1tZW51LWZhdm9yaXRlcy9zdWItbWVudS1mYXZvcml0ZXMuY29tcG9uZW50JztcbmltcG9ydCB7TWVudUZhdm9yaXRlc0NvbXBvbmVudH0gZnJvbSAnLi9tZW51LWZhdm9yaXRlcy9tZW51LWZhdm9yaXRlcy5jb21wb25lbnQnO1xuaW1wb3J0IHtCYXNlTWVudUZhdm9yaXRlc0NvbXBvbmVudH0gZnJvbSAnLi9tZW51LWZhdm9yaXRlcy9iYXNlLW1lbnUtZmF2b3JpdGVzLmNvbXBvbmVudCc7XG5pbXBvcnQge0Jhc2VGYXZvcml0ZXNDb21wb25lbnR9IGZyb20gJy4vbWVudS1mYXZvcml0ZXMvYmFzZS1mYXZvcml0ZXMuY29tcG9uZW50JztcbmltcG9ydCB7Rm9ybXNNb2R1bGV9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcbmltcG9ydCB7Tm90aWZpY2F0aW9uc01vZHVsZX0gZnJvbSAnLi4vLi4vY29udGFpbmVycy9ub3RpZmljYXRpb25zL25vdGlmaWNhdGlvbnMubW9kdWxlJztcbmltcG9ydCB7U2VhcmNoQmFyTW9kdWxlfSBmcm9tICcuLi9zZWFyY2gtYmFyL3NlYXJjaC1iYXIubW9kdWxlJztcbmltcG9ydCB7RHJvcGRvd25CdXR0b25Nb2R1bGV9IGZyb20gXCIuLi9kcm9wZG93bi1idXR0b24vZHJvcGRvd24tYnV0dG9uLm1vZHVsZVwiO1xuaW1wb3J0IHtSZWNlbnRseVZpZXdlZENvbXBvbmVudH0gZnJvbSBcIi4vcmVjZW50bHktdmlld2VkL3JlY2VudGx5LXZpZXdlZC5jb21wb25lbnRcIjtcbmltcG9ydCB7VHJ1bmNhdGVQaXBlfSBmcm9tIFwiLi4vLi4vcGlwZXMvdHJ1bmNhdGUvdHJ1bmNhdGUucGlwZVwiO1xuXG5cbkBOZ01vZHVsZSh7XG4gICAgZGVjbGFyYXRpb25zOiBbXG4gICAgICAgIE5hdmJhclVpQ29tcG9uZW50LFxuICAgICAgICBNZW51SXRlbUNvbXBvbmVudCxcbiAgICAgICAgQmFzZU1lbnVJdGVtQ29tcG9uZW50LFxuICAgICAgICBNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnQsXG4gICAgICAgIEJhc2VNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnQsXG4gICAgICAgIFN1Yk1lbnVSZWNlbnRseVZpZXdlZENvbXBvbmVudCxcbiAgICAgICAgQmFzZVN1Yk1lbnVSZWNlbnRseVZpZXdlZENvbXBvbmVudCxcbiAgICAgICAgQmFzZUZhdm9yaXRlc0NvbXBvbmVudCxcbiAgICAgICAgTWVudUZhdm9yaXRlc0NvbXBvbmVudCxcbiAgICAgICAgQmFzZU1lbnVGYXZvcml0ZXNDb21wb25lbnQsXG4gICAgICAgIFN1Yk1lbnVGYXZvcml0ZXNDb21wb25lbnQsXG4gICAgICAgIEJhc2VTdWJNZW51RmF2b3JpdGVzQ29tcG9uZW50LFxuICAgICAgICBIb21lTWVudUl0ZW1Db21wb25lbnQsXG4gICAgICAgIE1lbnVJdGVtTGlua0NvbXBvbmVudCxcbiAgICAgICAgQmFzZUhvbWVNZW51SXRlbUNvbXBvbmVudCxcbiAgICAgICAgQmFzZU1lbnVJdGVtTGlua0NvbXBvbmVudCxcbiAgICAgICAgR3JvdXBlZE1lbnVJdGVtQ29tcG9uZW50LFxuICAgICAgICBCYXNlR3JvdXBlZE1lbnVJdGVtQ29tcG9uZW50LFxuICAgICAgICBNZW51SXRlbXNMaXN0Q29tcG9uZW50LFxuICAgICAgICBCYXNlTWVudUl0ZW1zTGlzdENvbXBvbmVudCxcbiAgICAgICAgQmFzZU5hdmJhckNvbXBvbmVudFxuICAgIF0sXG4gICAgZXhwb3J0czogW1xuICAgICAgICBOYXZiYXJVaUNvbXBvbmVudCxcbiAgICAgICAgTWVudUl0ZW1Db21wb25lbnQsXG4gICAgICAgIEJhc2VNZW51SXRlbUNvbXBvbmVudCxcbiAgICAgICAgTWVudVJlY2VudGx5Vmlld2VkQ29tcG9uZW50LFxuICAgICAgICBCYXNlTWVudVJlY2VudGx5Vmlld2VkQ29tcG9uZW50LFxuICAgICAgICBTdWJNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnQsXG4gICAgICAgIEJhc2VTdWJNZW51UmVjZW50bHlWaWV3ZWRDb21wb25lbnQsXG4gICAgICAgIEJhc2VGYXZvcml0ZXNDb21wb25lbnQsXG4gICAgICAgIE1lbnVGYXZvcml0ZXNDb21wb25lbnQsXG4gICAgICAgIFN1Yk1lbnVGYXZvcml0ZXNDb21wb25lbnQsXG4gICAgICAgIEJhc2VTdWJNZW51RmF2b3JpdGVzQ29tcG9uZW50LFxuICAgICAgICBIb21lTWVudUl0ZW1Db21wb25lbnQsXG4gICAgICAgIE1lbnVJdGVtTGlua0NvbXBvbmVudCxcbiAgICAgICAgQmFzZUhvbWVNZW51SXRlbUNvbXBvbmVudCxcbiAgICAgICAgQmFzZU1lbnVJdGVtTGlua0NvbXBvbmVudCxcbiAgICAgICAgR3JvdXBlZE1lbnVJdGVtQ29tcG9uZW50LFxuICAgICAgICBCYXNlR3JvdXBlZE1lbnVJdGVtQ29tcG9uZW50LFxuICAgICAgICBNZW51SXRlbXNMaXN0Q29tcG9uZW50LFxuICAgICAgICBCYXNlTWVudUl0ZW1zTGlzdENvbXBvbmVudCxcbiAgICAgICAgQmFzZU5hdmJhckNvbXBvbmVudCxcbiAgICAgICAgTG9nb3V0VWlDb21wb25lbnRcbiAgICBdLFxuICAgIGltcG9ydHM6IFtcbiAgICAgICAgQ29tbW9uTW9kdWxlLFxuICAgICAgICBMb2dvVWlNb2R1bGUsXG4gICAgICAgIExvZ291dFVpTW9kdWxlLFxuICAgICAgICBOZ2JNb2R1bGUsXG4gICAgICAgIFJvdXRlck1vZHVsZSxcbiAgICAgICAgSW1hZ2VNb2R1bGUsXG4gICAgICAgIER5bmFtaWNNb2R1bGUsXG4gICAgICAgIExhYmVsTW9kdWxlLFxuICAgICAgICBGb3Jtc01vZHVsZSxcbiAgICAgICAgTm90aWZpY2F0aW9uc01vZHVsZSxcbiAgICAgICAgU2VhcmNoQmFyTW9kdWxlLFxuICAgICAgICBUcnVuY2F0ZVBpcGUsXG4gICAgICAgIFJlY2VudGx5Vmlld2VkQ29tcG9uZW50LFxuICAgICAgICBEcm9wZG93bkJ1dHRvbk1vZHVsZVxuICAgIF1cbn0pXG5leHBvcnQgY2xhc3MgTmF2YmFyVWlNb2R1bGUge1xufVxuIl19