/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, ViewChild } from '@angular/core';
import { DataTypeFormatter } from '../../../../services/formatters/data-type.formatter.service';
import { BaseMultiEnumComponent } from '../../../base/base-multienum.component';
import { LanguageStore } from '../../../../store/language/language.store';
import { FieldLogicManager } from '../../../field-logic/field-logic.manager';
import { FieldLogicDisplayManager } from '../../../field-logic-display/field-logic-display.manager';
import { ScreenSizeObserverService } from "../../../../services/ui/screen-size-observer/screen-size-observer.service";
import { take } from "rxjs/operators";
import { SystemConfigStore } from "../../../../store/system-config/system-config.store";
import { PrimeNGConfig } from "primeng/api";
import { MultiSelect } from "primeng/multiselect";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/language/language.store";
import * as i2 from "../../../../services/formatters/data-type.formatter.service";
import * as i3 from "../../../field-logic/field-logic.manager";
import * as i4 from "../../../field-logic-display/field-logic-display.manager";
import * as i5 from "../../../../services/ui/screen-size-observer/screen-size-observer.service";
import * as i6 from "../../../../store/system-config/system-config.store";
import * as i7 from "primeng/api";
import * as i8 from "@angular/forms";
import * as i9 from "primeng/multiselect";
import * as i10 from "../../../../components/image/image.component";
const _c0 = ["multiSelect"];
function MultiEnumEditFieldComponent_ng_template_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 6);
} }
function MultiEnumEditFieldComponent_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 7);
} }
function MultiEnumEditFieldComponent_ng_template_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-image", 8);
} }
class MultiEnumEditFieldComponent extends BaseMultiEnumComponent {
    constructor(languages, typeFormatter, logic, logicDisplay, screenSize, systemConfigStore, primengConfig) {
        super(languages, typeFormatter, logic, logicDisplay);
        this.languages = languages;
        this.typeFormatter = typeFormatter;
        this.logic = logic;
        this.logicDisplay = logicDisplay;
        this.screenSize = screenSize;
        this.systemConfigStore = systemConfigStore;
        this.primengConfig = primengConfig;
        this.placeholderLabel = '';
        this.selectedItemsLabel = '';
        this.emptyFilterLabel = '';
        this.maxSelectedLabels = 20;
        this.selectAll = false;
    }
    ngOnInit() {
        this.checkAndInitAsDynamicEnum();
        this.getTranslatedLabels();
        super.ngOnInit();
        const maxSelectedLabelsForDisplay = this.systemConfigStore.getUi('multiselect_max_number');
        this.screenSize.screenSize$
            .pipe(take(1))
            .subscribe((screenSize) => {
            this.maxSelectedLabels = maxSelectedLabelsForDisplay[screenSize] || this.maxSelectedLabels;
        });
        this.primengConfig.ripple = true;
        this.clearButton = {
            klass: ['btn', 'btn-sm', 'btn-outline-secondary', 'm-0', 'border-0'],
            onClick: (event) => {
                this.onRemove();
            },
            icon: 'cross'
        };
    }
    onAdd() {
        const value = this.selectedValues.map(option => option.value);
        this.field.valueList = value;
        this.field.formControl.setValue(value);
        this.field.formControl.markAsDirty();
        this.calculateSelectAll();
    }
    onSelectAll(event) {
        this.selectAll = event.checked;
        if (this.selectAll) {
            if (this.multiSelect.visibleOptions() && this.multiSelect.visibleOptions().length) {
                this.selectedValues = this.multiSelect.visibleOptions();
            }
            else {
                this.selectedValues = this.options;
            }
            this.onAdd();
        }
        else {
            this.selectedValues = [];
            this.onRemove();
        }
    }
    onRemove() {
        const value = this.selectedValues.map(option => option.value);
        this.field.valueList = value;
        this.field.formControl.setValue(value);
        this.field.formControl.markAsDirty();
        this.calculateSelectAll();
    }
    onClear() {
        this.selectedValues = [];
        this.multiSelect.filterValue = '';
        this.onRemove();
    }
    onPanelShow() {
        this.multiSelect.filterInputChild.nativeElement.focus();
        this.multiSelect.filterValue = '';
        this.calculateSelectAll();
    }
    onFilter() {
        this.calculateSelectAll();
    }
    getTranslatedLabels() {
        this.placeholderLabel = this.languages.getAppString('LBL_SELECT_ITEM') || '';
        this.selectedItemsLabel = this.languages.getAppString('LBL_ITEMS_SELECTED') || '';
        this.emptyFilterLabel = this.languages.getAppString('ERR_SEARCH_NO_RESULTS') || '';
    }
    calculateSelectAll() {
        const visibleOptions = this?.multiSelect?.visibleOptions() ?? [];
        const selectedValuesKeys = (this?.selectedValues ?? []).map(item => item.value);
        if (!visibleOptions.length || !selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        if (visibleOptions.length > selectedValuesKeys.length) {
            this.selectAll = false;
            return;
        }
        this.selectAll = visibleOptions.every(item => selectedValuesKeys.includes(item.value));
    }
    static { this.ɵfac = function MultiEnumEditFieldComponent_Factory(t) { return new (t || MultiEnumEditFieldComponent)(i0.ɵɵdirectiveInject(i1.LanguageStore), i0.ɵɵdirectiveInject(i2.DataTypeFormatter), i0.ɵɵdirectiveInject(i3.FieldLogicManager), i0.ɵɵdirectiveInject(i4.FieldLogicDisplayManager), i0.ɵɵdirectiveInject(i5.ScreenSizeObserverService), i0.ɵɵdirectiveInject(i6.SystemConfigStore), i0.ɵɵdirectiveInject(i7.PrimeNGConfig)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiEnumEditFieldComponent, selectors: [["scrm-multienum-edit"]], viewQuery: function MultiEnumEditFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.multiSelect = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 6, vars: 14, consts: [[1, "d-flex", "align-items-center"], [3, "options", "ngModel", "optionLabel", "placeholder", "selectedItemsLabel", "emptyFilterMessage", "maxSelectedLabels", "styleClass", "showToggleAll", "selectAll", "autoOptionFocus", "autofocusFilter", "showClear", "focusOnHover", "ngModelChange", "onChange", "onSelectAllChange", "onRemove", "onPanelShow", "onFilter", "onClear"], ["multiSelect", ""], ["pTemplate", "dropdownicon"], ["pTemplate", "filtericon"], ["pTemplate", "checkicon"], ["image", "down_carret"], ["image", "search"], ["image", "checkbox_cross"]], template: function MultiEnumEditFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "p-multiSelect", 1, 2);
            i0.ɵɵlistener("ngModelChange", function MultiEnumEditFieldComponent_Template_p_multiSelect_ngModelChange_1_listener($event) { return ctx.selectedValues = $event; })("onChange", function MultiEnumEditFieldComponent_Template_p_multiSelect_onChange_1_listener() { return ctx.onAdd(); })("onSelectAllChange", function MultiEnumEditFieldComponent_Template_p_multiSelect_onSelectAllChange_1_listener($event) { return ctx.onSelectAll($event); })("onRemove", function MultiEnumEditFieldComponent_Template_p_multiSelect_onRemove_1_listener() { return ctx.onRemove(); })("onPanelShow", function MultiEnumEditFieldComponent_Template_p_multiSelect_onPanelShow_1_listener() { return ctx.onPanelShow(); })("onFilter", function MultiEnumEditFieldComponent_Template_p_multiSelect_onFilter_1_listener() { return ctx.onFilter(); })("onClear", function MultiEnumEditFieldComponent_Template_p_multiSelect_onClear_1_listener() { return ctx.onClear(); });
            i0.ɵɵtemplate(3, MultiEnumEditFieldComponent_ng_template_3_Template, 1, 0, "ng-template", 3);
            i0.ɵɵtemplate(4, MultiEnumEditFieldComponent_ng_template_4_Template, 1, 0, "ng-template", 4);
            i0.ɵɵtemplate(5, MultiEnumEditFieldComponent_ng_template_5_Template, 1, 0, "ng-template", 5);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance(1);
            i0.ɵɵproperty("options", ctx.options)("ngModel", ctx.selectedValues)("optionLabel", "label")("placeholder", ctx.placeholderLabel)("selectedItemsLabel", "{0} " + ctx.selectedItemsLabel)("emptyFilterMessage", ctx.emptyFilterLabel)("maxSelectedLabels", ctx.maxSelectedLabels)("styleClass", "w-100 " + ctx.getInvalidClass())("showToggleAll", true)("selectAll", ctx.selectAll)("autoOptionFocus", false)("autofocusFilter", true)("showClear", true)("focusOnHover", true);
        } }, dependencies: [i8.NgControlStatus, i8.NgModel, i9.MultiSelect, i7.PrimeTemplate, i10.ImageComponent], encapsulation: 2 }); }
}
export { MultiEnumEditFieldComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiEnumEditFieldComponent, [{
        type: Component,
        args: [{ selector: 'scrm-multienum-edit', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"d-flex align-items-center\">\n    <p-multiSelect\n        #multiSelect\n        [options]=\"options\"\n        [(ngModel)]=\"selectedValues\"\n        [optionLabel]=\"'label'\"\n        (onChange)=\"onAdd()\"\n        (onSelectAllChange)=\"onSelectAll($event)\"\n        (onRemove)=\"onRemove()\"\n        (onPanelShow)=\"onPanelShow()\"\n        (onFilter)=\"onFilter()\"\n        [placeholder]=\"placeholderLabel\"\n        [selectedItemsLabel]=\"'{0} ' + selectedItemsLabel\"\n        [emptyFilterMessage]=\"emptyFilterLabel\"\n        [maxSelectedLabels]=\"maxSelectedLabels\"\n        [styleClass]=\"'w-100 ' + getInvalidClass()\"\n        [showToggleAll]=\"true\"\n        [selectAll]=\"selectAll\"\n        [autoOptionFocus]=\"false\"\n        [autofocusFilter]=\"true\"\n        [showClear]=\"true\"\n        (onClear)=\"onClear()\"\n        [focusOnHover]=\"true\"\n    >\n        <ng-template pTemplate=\"dropdownicon\">\n            <scrm-image image=\"down_carret\"></scrm-image>\n        </ng-template>\n        <ng-template pTemplate=\"filtericon\">\n            <scrm-image image=\"search\"></scrm-image>\n        </ng-template>\n        <ng-template pTemplate=\"checkicon\">\n            <scrm-image image=\"checkbox_cross\"></scrm-image>\n        </ng-template>\n    </p-multiSelect>\n</div>\n\n" }]
    }], function () { return [{ type: i1.LanguageStore }, { type: i2.DataTypeFormatter }, { type: i3.FieldLogicManager }, { type: i4.FieldLogicDisplayManager }, { type: i5.ScreenSizeObserverService }, { type: i6.SystemConfigStore }, { type: i7.PrimeNGConfig }]; }, { multiSelect: [{
            type: ViewChild,
            args: ['multiSelect']
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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