import { Injectable } from '@angular/core';
import { MetadataStore } from '../../../store/metadata/metadata.store.service';
import { deepClone } from 'common';
import { ProcessService } from '../../process/process.service';
import { take } from 'rxjs/operators';
import { GlobalRecentlyViewedStore } from "../../../store/global-recently-viewed/global-recently-viewed.store";
import { ModuleNameMapper } from "../module-name-mapper/module-name-mapper.service";
import { AppMetadataStore } from "../../../store/app-metadata/app-metadata.store.service";
import { AppStateStore } from "../../../store/app-state/app-state.store";
import { SystemConfigStore } from "../../../store/system-config/system-config.store";
import * as i0 from "@angular/core";
import * as i1 from "../../../store/metadata/metadata.store.service";
import * as i2 from "../../../store/global-recently-viewed/global-recently-viewed.store";
import * as i3 from "../../process/process.service";
import * as i4 from "../module-name-mapper/module-name-mapper.service";
import * as i5 from "../../../store/app-metadata/app-metadata.store.service";
import * as i6 from "../../../store/system-config/system-config.store";
import * as i7 from "../../../store/app-state/app-state.store";
class RecentlyViewedService {
    constructor(metadata, globalRecentlyViewedStore, processService, moduleNameMapper, appMetadataStore, systemConfigs, appStateStore) {
        this.metadata = metadata;
        this.globalRecentlyViewedStore = globalRecentlyViewedStore;
        this.processService = processService;
        this.moduleNameMapper = moduleNameMapper;
        this.appMetadataStore = appMetadataStore;
        this.systemConfigs = systemConfigs;
        this.appStateStore = appStateStore;
    }
    /**
     * Public Api
     */
    /**
     * On navigation add
     * @param module
     * @param route
     */
    onNavigationAdd(module, route) {
        let mode = 'detail';
        const data = (route && route.data) || {};
        if (data.mode) {
            mode = data.mode;
        }
        const recordId = route?.params?.record ?? null;
        if (recordId && mode !== 'create') {
            const recentlyViewed = this.buildRecentlyViewed(module, recordId);
            this.addRecentlyViewed(module, recentlyViewed);
        }
    }
    /**
     * Build new recently viewed
     * @param module
     * @param id
     * @param view
     */
    buildRecentlyViewed(module, id, view = 'detailview') {
        module = this.moduleNameMapper.toLegacy(module);
        return deepClone({
            module: 'Tracker',
            type: 'Tracker',
            attributes: {
                module_name: module ?? '',
                item_id: id ?? '',
                action: view ?? '',
            },
        });
    }
    /**
     * Add recently viewed
     * @param module
     * @param viewed
     */
    addRecentlyViewed(module, viewed) {
        this.saveRecentlyViewed(module, viewed);
    }
    /**
     * Save recently viewed to backend
     * @param module
     * @param viewed
     */
    saveRecentlyViewed(module, viewed) {
        const processType = 'add-recently-viewed';
        const options = {
            recentlyViewed: viewed
        };
        setTimeout(() => {
            this.processService.submit(processType, options).pipe(take(1)).subscribe(result => {
                const saved = {
                    id: viewed.id ?? '',
                    module: viewed.module ?? '',
                    attributes: { ...(viewed.attributes ?? {}) },
                };
                const tracker = result?.data?.tracker ?? null;
                if (tracker === null) {
                    return;
                }
                saved.attributes.item_summary = tracker.item_summary;
                const newItemId = saved?.attributes?.item_id ?? '';
                const metadata = this.metadata.getModuleMeta(module);
                const current = metadata?.recentlyViewed ?? null;
                if (current) {
                    let cleared = current.filter(item => ((item?.attributes?.item_id ?? '') !== newItemId));
                    cleared.unshift(saved);
                    metadata.recentlyViewed = cleared;
                }
                this.globalRecentlyViewedStore.addToState(saved);
                this.metadata.setModuleMetadata(module, metadata);
            });
        }, 500);
    }
    conditionalGlobalRefresh(view = '') {
        const reloadActions = this.systemConfigs.getUi('global_recently_viewed_reload_actions') ?? null;
        const previousModule = this.getModule();
        if (!view) {
            view = this.getView();
        }
        if (!reloadActions || !previousModule) {
            return;
        }
        const actions = reloadActions[previousModule] ?? reloadActions['any'] ?? [];
        if (!actions || !actions.length) {
            return;
        }
        const reload = actions.some(action => {
            return action === 'any' || action === view;
        });
        if (reload) {
            this.appMetadataStore.load(this.getModule(), ['globalRecentlyViewed'], false).pipe(take(1)).subscribe();
        }
    }
    getModule() {
        return this.appStateStore.getModule();
    }
    getView() {
        return this.appStateStore.getView();
    }
    static { this.ɵfac = function RecentlyViewedService_Factory(t) { return new (t || RecentlyViewedService)(i0.ɵɵinject(i1.MetadataStore), i0.ɵɵinject(i2.GlobalRecentlyViewedStore), i0.ɵɵinject(i3.ProcessService), i0.ɵɵinject(i4.ModuleNameMapper), i0.ɵɵinject(i5.AppMetadataStore), i0.ɵɵinject(i6.SystemConfigStore), i0.ɵɵinject(i7.AppStateStore)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecentlyViewedService, factory: RecentlyViewedService.ɵfac, providedIn: 'root' }); }
}
export { RecentlyViewedService };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecentlyViewedService, [{
        type: Injectable,
        args: [{ providedIn: 'root' }]
    }], function () { return [{ type: i1.MetadataStore }, { type: i2.GlobalRecentlyViewedStore }, { type: i3.ProcessService }, { type: i4.ModuleNameMapper }, { type: i5.AppMetadataStore }, { type: i6.SystemConfigStore }, { type: i7.AppStateStore }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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