/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from "@angular/core";
import { PaginationType, emptyObject } from 'common';
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { UserPreferenceStore } from "../../../../store/user-preference/user-preference.store";
import { LocalStorageService } from "../../../../services/local-storage/local-storage.service";
import { BehaviorSubject } from "rxjs";
import { ActivatedRoute } from "@angular/router";
import { toNumber } from "lodash-es";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/local-storage/local-storage.service";
import * as i2 from "../../../../store/user-preference/user-preference.store";
import * as i3 from "../../../../store/app-state/app-state.store";
import * as i4 from "@angular/router";
class RecordPaginationService {
    constructor(localStorageService, preferences, appStateStore, route) {
        this.localStorageService = localStorageService;
        this.preferences = preferences;
        this.appStateStore = appStateStore;
        this.route = route;
        this.nextRecordSubject = new BehaviorSubject(false);
        this.nextRecord$ = this.nextRecordSubject.asObservable();
        this.paginationType = PaginationType.PAGINATION;
        this.subs = [];
    }
    triggerNextRecord(value) {
        this.nextRecordSubject.next(value);
    }
    updateRecordListLocalStorage(records, pagination) {
        const module = this.getModule();
        const recordPaginationObj = {
            pagination: pagination,
            recordIds: this.mapRecordIds(records)
        };
        this.updatePaginationLocalStorage(pagination);
        this.savePreference(module, 'current-record-pagination', recordPaginationObj);
    }
    updatePaginationLocalStorage(pagination) {
        const module = this.getModule();
        const key = module + '-' + 'listview-current-pagination';
        this.localStorageService.set(key, pagination);
    }
    savePreference(module, storageKey, value) {
        this.preferences.setUi(module, this.getPreferenceKey(storageKey), value);
    }
    getPreferenceKey(storageKey) {
        return 'recordview-' + storageKey;
    }
    mapRecordIds(records) {
        return records.map(record => ({ id: record.id }));
    }
    getModule() {
        return this.appStateStore.getModule();
    }
    getTotalRecords() {
        const key = this.getModule() + '-' + 'listview-current-pagination';
        const currentPagination = this.localStorageService.get(key);
        return currentPagination?.total;
    }
    checkRecordValid(recordId) {
        const paginationObj = this.getRecordPaginationObj(this.getModule());
        const pagination = paginationObj?.pagination;
        const recordIds = paginationObj?.recordIds;
        if (!pagination) {
            return false;
        }
        const pageSize = this.getPageSize();
        const offset = this.getOffsetFromUrl();
        if (this.paginationType === PaginationType.LOAD_MORE && (offset > pageSize)) {
            return false;
        }
        let index = (offset - 1) % pageSize;
        if (this.paginationType === PaginationType.LOAD_MORE) {
            index = offset - 1;
        }
        if (index >= 0 && index < recordIds.length) {
            return recordIds[index]?.id === recordId;
        }
        return false;
    }
    getPageSize() {
        const paginationObj = this.getRecordPaginationObj(this.getModule());
        return paginationObj?.pagination?.pageSize;
    }
    getOffsetFromUrl() {
        const queryParams = this.route.snapshot.queryParamMap;
        return toNumber(queryParams.get('offset'));
    }
    getRecordPaginationObj(module) {
        const key = module + '-' + 'recordview-current-record-pagination';
        const data = this.localStorageService.get(key)[module];
        if (!data || emptyObject(data)) {
            return;
        }
        return data;
    }
    static { this.ɵfac = function RecordPaginationService_Factory(t) { return new (t || RecordPaginationService)(i0.ɵɵinject(i1.LocalStorageService), i0.ɵɵinject(i2.UserPreferenceStore), i0.ɵɵinject(i3.AppStateStore), i0.ɵɵinject(i4.ActivatedRoute)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordPaginationService, factory: RecordPaginationService.ɵfac, providedIn: 'root' }); }
}
export { RecordPaginationService };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordPaginationService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.LocalStorageService }, { type: i2.UserPreferenceStore }, { type: i3.AppStateStore }, { type: i4.ActivatedRoute }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVjb3JkLXBhZ2luYXRpb24uc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi92aWV3cy9yZWNvcmQvc3RvcmUvcmVjb3JkLXBhZ2luYXRpb24vcmVjb3JkLXBhZ2luYXRpb24uc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBd0JHO0FBRUgsT0FBTyxFQUFDLFVBQVUsRUFBQyxNQUFNLGVBQWUsQ0FBQztBQUN6QyxPQUFPLEVBQWEsY0FBYyxFQUFxQixXQUFXLEVBQUMsTUFBTSxRQUFRLENBQUM7QUFDbEYsT0FBTyxFQUFDLGFBQWEsRUFBQyxNQUFNLDZDQUE2QyxDQUFDO0FBQzFFLE9BQU8sRUFBQyxtQkFBbUIsRUFBQyxNQUFNLHlEQUF5RCxDQUFDO0FBQzVGLE9BQU8sRUFBQyxtQkFBbUIsRUFBQyxNQUFNLDBEQUEwRCxDQUFDO0FBQzdGLE9BQU8sRUFBQyxlQUFlLEVBQWUsTUFBTSxNQUFNLENBQUM7QUFDbkQsT0FBTyxFQUFDLGNBQWMsRUFBQyxNQUFNLGlCQUFpQixDQUFDO0FBQy9DLE9BQU8sRUFBQyxRQUFRLEVBQUMsTUFBTSxXQUFXLENBQUM7Ozs7OztBQUduQyxNQUdhLHVCQUF1QjtJQVFoQyxZQUNjLG1CQUF3QyxFQUN4QyxXQUFnQyxFQUNoQyxhQUE0QixFQUM1QixLQUFxQjtRQUhyQix3QkFBbUIsR0FBbkIsbUJBQW1CLENBQXFCO1FBQ3hDLGdCQUFXLEdBQVgsV0FBVyxDQUFxQjtRQUNoQyxrQkFBYSxHQUFiLGFBQWEsQ0FBZTtRQUM1QixVQUFLLEdBQUwsS0FBSyxDQUFnQjtRQVYzQixzQkFBaUIsR0FBRyxJQUFJLGVBQWUsQ0FBVSxLQUFLLENBQUMsQ0FBQztRQUNoRSxnQkFBVyxHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUVwRCxtQkFBYyxHQUFXLGNBQWMsQ0FBQyxVQUFVLENBQUM7UUFDekMsU0FBSSxHQUFtQixFQUFFLENBQUM7SUFPakMsQ0FBQztJQUVHLGlCQUFpQixDQUFDLEtBQWM7UUFDbkMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRU0sNEJBQTRCLENBQUMsT0FBaUIsRUFBRSxVQUFzQjtRQUN6RSxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7UUFDaEMsTUFBTSxtQkFBbUIsR0FBMEI7WUFDL0MsVUFBVSxFQUFFLFVBQVU7WUFDdEIsU0FBUyxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDO1NBQ3hDLENBQUM7UUFDRixJQUFJLENBQUMsNEJBQTRCLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDOUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsMkJBQTJCLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztJQUNsRixDQUFDO0lBRU0sNEJBQTRCLENBQUMsVUFBc0I7UUFDdEQsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ2hDLE1BQU0sR0FBRyxHQUFHLE1BQU0sR0FBRyxHQUFHLEdBQUcsNkJBQTZCLENBQUM7UUFDekQsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsVUFBVSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVTLGNBQWMsQ0FBQyxNQUFjLEVBQUUsVUFBa0IsRUFBRSxLQUFVO1FBQ25FLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsVUFBVSxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDN0UsQ0FBQztJQUVTLGdCQUFnQixDQUFDLFVBQWtCO1FBQ3pDLE9BQU8sYUFBYSxHQUFHLFVBQVUsQ0FBQztJQUN0QyxDQUFDO0lBRU0sWUFBWSxDQUFDLE9BQWlCO1FBQ2pDLE9BQU8sT0FBTyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxFQUFFLEVBQUUsTUFBTSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRU0sU0FBUztRQUNaLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsQ0FBQztJQUMxQyxDQUFDO0lBRU0sZUFBZTtRQUNsQixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsR0FBRyxHQUFHLDZCQUE2QixDQUFDO1FBQ25FLE1BQU0saUJBQWlCLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQWUsQ0FBQztRQUMxRSxPQUFPLGlCQUFpQixFQUFFLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBRU0sZ0JBQWdCLENBQUMsUUFBZ0I7UUFDcEMsTUFBTSxhQUFhLEdBQTBCLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQztRQUMzRixNQUFNLFVBQVUsR0FBZSxhQUFhLEVBQUUsVUFBVSxDQUFDO1FBQ3pELE1BQU0sU0FBUyxHQUFnQixhQUFhLEVBQUUsU0FBUyxDQUFDO1FBRXhELElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDYixPQUFPLEtBQUssQ0FBQztTQUNoQjtRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUNwQyxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUV2QyxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssY0FBYyxDQUFDLFNBQVMsSUFBSSxDQUFDLE1BQU0sR0FBRyxRQUFRLENBQUMsRUFBRTtZQUN6RSxPQUFPLEtBQUssQ0FBQztTQUNoQjtRQUVELElBQUksS0FBSyxHQUFHLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxHQUFHLFFBQVEsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssY0FBYyxDQUFDLFNBQVMsRUFBRTtZQUNsRCxLQUFLLEdBQUcsTUFBTSxHQUFJLENBQUMsQ0FBQztTQUN2QjtRQUNELElBQUksS0FBSyxJQUFJLENBQUMsSUFBSSxLQUFLLEdBQUcsU0FBUyxDQUFDLE1BQU0sRUFBRTtZQUV4QyxPQUFPLFNBQVMsQ0FBQyxLQUFLLENBQUMsRUFBRSxFQUFFLEtBQUssUUFBUSxDQUFDO1NBQzVDO1FBRUQsT0FBTyxLQUFLLENBQUM7SUFDakIsQ0FBQztJQUVNLFdBQVc7UUFDZCxNQUFNLGFBQWEsR0FBMEIsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQzNGLE9BQU8sYUFBYSxFQUFFLFVBQVUsRUFBRSxRQUFRLENBQUM7SUFDL0MsQ0FBQztJQUVNLGdCQUFnQjtRQUNuQixNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUM7UUFDdEQsT0FBTyxRQUFRLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFFTSxzQkFBc0IsQ0FBQyxNQUFjO1FBQ3hDLE1BQU0sR0FBRyxHQUFHLE1BQU0sR0FBRyxHQUFHLEdBQUcsc0NBQXNDLENBQUM7UUFDbEUsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN2RCxJQUFJLENBQUMsSUFBSSxJQUFJLFdBQVcsQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUM1QixPQUFPO1NBQ1Y7UUFDRCxPQUFPLElBQUksQ0FBQztJQUNoQixDQUFDO3dGQXRHUSx1QkFBdUI7dUVBQXZCLHVCQUF1QixXQUF2Qix1QkFBdUIsbUJBRnBCLE1BQU07O1NBRVQsdUJBQXVCO3VGQUF2Qix1QkFBdUI7Y0FIbkMsVUFBVTtlQUFDO2dCQUNSLFVBQVUsRUFBRSxNQUFNO2FBQ3JCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4gKiBDb3B5cmlnaHQgKEMpIDIwMjQgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuICogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiAqIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiAqIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiAqIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuICogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4gKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuICogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuICogZGV0YWlscy5cbiAqXG4gKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgPGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy8+LlxuICpcbiAqIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuICogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiAqIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4gKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiAqL1xuXG5pbXBvcnQge0luamVjdGFibGV9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XG5pbXBvcnQge1BhZ2luYXRpb24sIFBhZ2luYXRpb25UeXBlLCBSZWNvcmQsIE9iamVjdE1hcCwgZW1wdHlPYmplY3R9IGZyb20gJ2NvbW1vbic7XG5pbXBvcnQge0FwcFN0YXRlU3RvcmV9IGZyb20gXCIuLi8uLi8uLi8uLi9zdG9yZS9hcHAtc3RhdGUvYXBwLXN0YXRlLnN0b3JlXCI7XG5pbXBvcnQge1VzZXJQcmVmZXJlbmNlU3RvcmV9IGZyb20gXCIuLi8uLi8uLi8uLi9zdG9yZS91c2VyLXByZWZlcmVuY2UvdXNlci1wcmVmZXJlbmNlLnN0b3JlXCI7XG5pbXBvcnQge0xvY2FsU3RvcmFnZVNlcnZpY2V9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9sb2NhbC1zdG9yYWdlL2xvY2FsLXN0b3JhZ2Uuc2VydmljZVwiO1xuaW1wb3J0IHtCZWhhdmlvclN1YmplY3QsIFN1YnNjcmlwdGlvbn0gZnJvbSBcInJ4anNcIjtcbmltcG9ydCB7QWN0aXZhdGVkUm91dGV9IGZyb20gXCJAYW5ndWxhci9yb3V0ZXJcIjtcbmltcG9ydCB7dG9OdW1iZXJ9IGZyb20gXCJsb2Rhc2gtZXNcIjtcbmltcG9ydCB7UmVjb3JkUGFnaW5hdGlvbk1vZGVsfSBmcm9tIFwiLi9yZWNvcmQtcGFnaW5hdGlvbi5tb2RlbFwiO1xuXG5ASW5qZWN0YWJsZSh7XG4gICAgcHJvdmlkZWRJbjogJ3Jvb3QnXG59KVxuZXhwb3J0IGNsYXNzIFJlY29yZFBhZ2luYXRpb25TZXJ2aWNlIHtcblxuICAgIHByaXZhdGUgbmV4dFJlY29yZFN1YmplY3QgPSBuZXcgQmVoYXZpb3JTdWJqZWN0PGJvb2xlYW4+KGZhbHNlKTtcbiAgICBuZXh0UmVjb3JkJCA9IHRoaXMubmV4dFJlY29yZFN1YmplY3QuYXNPYnNlcnZhYmxlKCk7XG5cbiAgICBwYWdpbmF0aW9uVHlwZTogc3RyaW5nID0gUGFnaW5hdGlvblR5cGUuUEFHSU5BVElPTjtcbiAgICBwcm90ZWN0ZWQgc3ViczogU3Vic2NyaXB0aW9uW10gPSBbXTtcblxuICAgIGNvbnN0cnVjdG9yKFxuICAgICAgICBwcm90ZWN0ZWQgbG9jYWxTdG9yYWdlU2VydmljZTogTG9jYWxTdG9yYWdlU2VydmljZSxcbiAgICAgICAgcHJvdGVjdGVkIHByZWZlcmVuY2VzOiBVc2VyUHJlZmVyZW5jZVN0b3JlLFxuICAgICAgICBwcm90ZWN0ZWQgYXBwU3RhdGVTdG9yZTogQXBwU3RhdGVTdG9yZSxcbiAgICAgICAgcHJvdGVjdGVkIHJvdXRlOiBBY3RpdmF0ZWRSb3V0ZSxcbiAgICApIHt9XG5cbiAgICBwdWJsaWMgdHJpZ2dlck5leHRSZWNvcmQodmFsdWU6IGJvb2xlYW4pOiB2b2lkIHtcbiAgICAgICAgdGhpcy5uZXh0UmVjb3JkU3ViamVjdC5uZXh0KHZhbHVlKTtcbiAgICB9XG5cbiAgICBwdWJsaWMgdXBkYXRlUmVjb3JkTGlzdExvY2FsU3RvcmFnZShyZWNvcmRzOiBSZWNvcmRbXSwgcGFnaW5hdGlvbjogUGFnaW5hdGlvbik6IHZvaWQge1xuICAgICAgICBjb25zdCBtb2R1bGUgPSB0aGlzLmdldE1vZHVsZSgpO1xuICAgICAgICBjb25zdCByZWNvcmRQYWdpbmF0aW9uT2JqOiBSZWNvcmRQYWdpbmF0aW9uTW9kZWwgPSB7XG4gICAgICAgICAgICBwYWdpbmF0aW9uOiBwYWdpbmF0aW9uLFxuICAgICAgICAgICAgcmVjb3JkSWRzOiB0aGlzLm1hcFJlY29yZElkcyhyZWNvcmRzKVxuICAgICAgICB9O1xuICAgICAgICB0aGlzLnVwZGF0ZVBhZ2luYXRpb25Mb2NhbFN0b3JhZ2UocGFnaW5hdGlvbik7XG4gICAgICAgIHRoaXMuc2F2ZVByZWZlcmVuY2UobW9kdWxlLCAnY3VycmVudC1yZWNvcmQtcGFnaW5hdGlvbicsIHJlY29yZFBhZ2luYXRpb25PYmopO1xuICAgIH1cblxuICAgIHB1YmxpYyB1cGRhdGVQYWdpbmF0aW9uTG9jYWxTdG9yYWdlKHBhZ2luYXRpb246IFBhZ2luYXRpb24pOiB2b2lkIHtcbiAgICAgICAgY29uc3QgbW9kdWxlID0gdGhpcy5nZXRNb2R1bGUoKTtcbiAgICAgICAgY29uc3Qga2V5ID0gbW9kdWxlICsgJy0nICsgJ2xpc3R2aWV3LWN1cnJlbnQtcGFnaW5hdGlvbic7XG4gICAgICAgIHRoaXMubG9jYWxTdG9yYWdlU2VydmljZS5zZXQoa2V5LCBwYWdpbmF0aW9uKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgc2F2ZVByZWZlcmVuY2UobW9kdWxlOiBzdHJpbmcsIHN0b3JhZ2VLZXk6IHN0cmluZywgdmFsdWU6IGFueSk6IHZvaWQge1xuICAgICAgICB0aGlzLnByZWZlcmVuY2VzLnNldFVpKG1vZHVsZSwgdGhpcy5nZXRQcmVmZXJlbmNlS2V5KHN0b3JhZ2VLZXkpLCB2YWx1ZSk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldFByZWZlcmVuY2VLZXkoc3RvcmFnZUtleTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICAgICAgcmV0dXJuICdyZWNvcmR2aWV3LScgKyBzdG9yYWdlS2V5O1xuICAgIH1cblxuICAgIHB1YmxpYyBtYXBSZWNvcmRJZHMocmVjb3JkczogUmVjb3JkW10pOiBPYmplY3RNYXBbXSB7XG4gICAgICAgIHJldHVybiByZWNvcmRzLm1hcChyZWNvcmQgPT4gKHsgaWQ6IHJlY29yZC5pZCB9KSk7XG4gICAgfVxuXG4gICAgcHVibGljIGdldE1vZHVsZSgpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gdGhpcy5hcHBTdGF0ZVN0b3JlLmdldE1vZHVsZSgpO1xuICAgIH1cblxuICAgIHB1YmxpYyBnZXRUb3RhbFJlY29yZHMoKTogbnVtYmVyIHtcbiAgICAgICAgY29uc3Qga2V5ID0gdGhpcy5nZXRNb2R1bGUoKSArICctJyArICdsaXN0dmlldy1jdXJyZW50LXBhZ2luYXRpb24nO1xuICAgICAgICBjb25zdCBjdXJyZW50UGFnaW5hdGlvbiA9IHRoaXMubG9jYWxTdG9yYWdlU2VydmljZS5nZXQoa2V5KSBhcyBQYWdpbmF0aW9uO1xuICAgICAgICByZXR1cm4gY3VycmVudFBhZ2luYXRpb24/LnRvdGFsO1xuICAgIH1cblxuICAgIHB1YmxpYyBjaGVja1JlY29yZFZhbGlkKHJlY29yZElkOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICAgICAgY29uc3QgcGFnaW5hdGlvbk9iajogUmVjb3JkUGFnaW5hdGlvbk1vZGVsID0gdGhpcy5nZXRSZWNvcmRQYWdpbmF0aW9uT2JqKHRoaXMuZ2V0TW9kdWxlKCkpO1xuICAgICAgICBjb25zdCBwYWdpbmF0aW9uOiBQYWdpbmF0aW9uID0gcGFnaW5hdGlvbk9iaj8ucGFnaW5hdGlvbjtcbiAgICAgICAgY29uc3QgcmVjb3JkSWRzOiBPYmplY3RNYXBbXSA9IHBhZ2luYXRpb25PYmo/LnJlY29yZElkcztcblxuICAgICAgICBpZiAoIXBhZ2luYXRpb24pIHtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHBhZ2VTaXplID0gdGhpcy5nZXRQYWdlU2l6ZSgpO1xuICAgICAgICBjb25zdCBvZmZzZXQgPSB0aGlzLmdldE9mZnNldEZyb21VcmwoKTtcblxuICAgICAgICBpZiAodGhpcy5wYWdpbmF0aW9uVHlwZSA9PT0gUGFnaW5hdGlvblR5cGUuTE9BRF9NT1JFICYmIChvZmZzZXQgPiBwYWdlU2l6ZSkpIHtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBpbmRleCA9IChvZmZzZXQgLSAxKSAlIHBhZ2VTaXplO1xuICAgICAgICBpZiAodGhpcy5wYWdpbmF0aW9uVHlwZSA9PT0gUGFnaW5hdGlvblR5cGUuTE9BRF9NT1JFKSB7XG4gICAgICAgICAgICBpbmRleCA9IG9mZnNldCAgLSAxO1xuICAgICAgICB9XG4gICAgICAgIGlmIChpbmRleCA+PSAwICYmIGluZGV4IDwgcmVjb3JkSWRzLmxlbmd0aCkge1xuXG4gICAgICAgICAgICByZXR1cm4gcmVjb3JkSWRzW2luZGV4XT8uaWQgPT09IHJlY29yZElkO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cblxuICAgIHB1YmxpYyBnZXRQYWdlU2l6ZSgpOiBudW1iZXIge1xuICAgICAgICBjb25zdCBwYWdpbmF0aW9uT2JqOiBSZWNvcmRQYWdpbmF0aW9uTW9kZWwgPSB0aGlzLmdldFJlY29yZFBhZ2luYXRpb25PYmoodGhpcy5nZXRNb2R1bGUoKSk7XG4gICAgICAgIHJldHVybiBwYWdpbmF0aW9uT2JqPy5wYWdpbmF0aW9uPy5wYWdlU2l6ZTtcbiAgICB9XG5cbiAgICBwdWJsaWMgZ2V0T2Zmc2V0RnJvbVVybCgpOiBudW1iZXIge1xuICAgICAgICBjb25zdCBxdWVyeVBhcmFtcyA9IHRoaXMucm91dGUuc25hcHNob3QucXVlcnlQYXJhbU1hcDtcbiAgICAgICAgcmV0dXJuIHRvTnVtYmVyKHF1ZXJ5UGFyYW1zLmdldCgnb2Zmc2V0JykpO1xuICAgIH1cblxuICAgIHB1YmxpYyBnZXRSZWNvcmRQYWdpbmF0aW9uT2JqKG1vZHVsZTogc3RyaW5nKTogUmVjb3JkUGFnaW5hdGlvbk1vZGVsIHtcbiAgICAgICAgY29uc3Qga2V5ID0gbW9kdWxlICsgJy0nICsgJ3JlY29yZHZpZXctY3VycmVudC1yZWNvcmQtcGFnaW5hdGlvbic7XG4gICAgICAgIGNvbnN0IGRhdGEgPSB0aGlzLmxvY2FsU3RvcmFnZVNlcnZpY2UuZ2V0KGtleSlbbW9kdWxlXTtcbiAgICAgICAgaWYgKCFkYXRhIHx8IGVtcHR5T2JqZWN0KGRhdGEpKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIGRhdGE7XG4gICAgfVxufVxuIl19