/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { OnInit } from '@angular/core';
import { ButtonInterface, DropdownButtonInterface, DropdownButtonSection, DropdownButtonSectionMap } from 'common';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { PlacementArray } from '@ng-bootstrap/ng-bootstrap/util/positioning';
import { LanguageStore } from '../../store/language/language.store';
import { SystemConfigStore } from "../../store/system-config/system-config.store";
import * as i0 from "@angular/core";
export declare class DropdownButtonComponent implements OnInit {
    language: LanguageStore;
    protected systemConfigStore: SystemConfigStore;
    config: DropdownButtonInterface;
    disabled: boolean;
    autoClose: boolean | 'outside' | 'inside';
    sections: DropdownButtonSection[];
    sectionsEnabled: boolean;
    charSize: {
        minLength: number;
        mediumLength: number;
        maxLength: number;
    };
    constructor(language: LanguageStore, systemConfigStore: SystemConfigStore);
    isDropdown(item: ButtonInterface): boolean;
    click(onClick: Function, dropdown: NgbDropdown): void;
    close(dropdown: NgbDropdown): void;
    ngOnInit(): void;
    preprocessItems(items: any[]): void;
    /**
     * Get section from map, initialize if not on map
     * @param sectionsConfig
     * @param sectionKey
     * @param sections
     * @protected
     */
    protected getSection(sectionsConfig: DropdownButtonSectionMap, sectionKey: string, sections: DropdownButtonSectionMap): DropdownButtonSection;
    getPlacement(): PlacementArray;
    static ɵfac: i0.ɵɵFactoryDeclaration<DropdownButtonComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<DropdownButtonComponent, "scrm-dropdown-button", never, { "config": { "alias": "config"; "required": false; }; "disabled": { "alias": "disabled"; "required": false; }; "autoClose": { "alias": "autoClose"; "required": false; }; }, {}, never, never, false, never>;
}
//# sourceMappingURL=dropdown-button.component.d.ts.map