/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2024 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Field, Record } from "common";
import { AsyncValidatorFn, ValidatorFn } from "@angular/forms";
import * as i0 from "@angular/core";
export declare class RecordValidationHandler {
    /**
     * Initialize Record Validators
     * @param record
     */
    initValidators(record: Record): void;
    /**
     * reset record field validators
     * @param record
     */
    resetValidators(record: Record): void;
    /**
     * Set field validators
     * @param field
     * @param validators
     * @param asyncValidators
     */
    setFormControlValidators(field: Field, validators: ValidatorFn[], asyncValidators: AsyncValidatorFn[]): void;
    /**
     * Reset field validators
     * @param field
     */
    resetFormControlValidators(field: Field): void;
    /**
     * Initialize Field validators
     * @param field
     */
    initFieldValidators(field: Field): void;
    /**
     * Initialize Field validators
     * @param field
     */
    resetFieldValidators(field: Field): void;
    /**
     * Initialize Line Items validators
     * @param field
     */
    initLineItemsValidators(field: Field): void;
    /**
     * Initialize Line Items validators
     * @param field
     */
    resetLineItemsValidators(field: Field): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<RecordValidationHandler, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<RecordValidationHandler>;
}
//# sourceMappingURL=record-validation.handler.d.ts.map